package com.zoyi.channel.plugin.android.view.dialog.bottom_sheet;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.view.ViewGroup;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.view.dialog.bottom_sheet.icon_button.IconButtonView;
import com.zoyi.channel.plugin.android.view.dialog.bottom_sheet.listener.OnIconButtonClickListener;

import java.util.ArrayList;

public class IconButtonBottomSheetDialog extends BaseBottomSheetDialog {

  private ArrayList<IconButtonView> buttons = new ArrayList<>();

  public IconButtonBottomSheetDialog(@NonNull Context context) {
    super(context);

    paddingTop = 6;
    paddingBottom = 6;
  }

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    setOrientation(LinearLayout.VERTICAL);

    setDialogView();
  }

  private void setDialogView() {
    for (IconButtonView iconButton : buttons) {
      if (iconButton != null) {
        addContentView(iconButton);
      }
    }
  }

  public IconButtonBottomSheetDialog addButton(
      @DrawableRes int iconDrawableId,
      String messageText,
      OnIconButtonClickListener listener
  ) {
    buttons.add(createButton(iconDrawableId, messageText, R.color.ch_grey700, R.color.ch_grey900, listener));

    return this;
  }

  public IconButtonBottomSheetDialog addButton(
      @DrawableRes int iconDrawableId,
      String messageText,
      int iconColorId,
      int textColorId,
      OnIconButtonClickListener listener
  ) {
    buttons.add(createButton(iconDrawableId, messageText, iconColorId, textColorId, listener));

    return this;
  }

  private IconButtonView createButton(
      @DrawableRes int iconDrawable,
      String messageText,
      int iconColorId,
      int textColorId,
      OnIconButtonClickListener listener
  ) {
    IconButtonView iconButton = new IconButtonView(getContext());
    iconButton.setData(iconDrawable, messageText, iconColorId, textColorId);
    iconButton.setOnClickListener( v -> {
      if (listener != null) {
        listener.onButtonClick();
      }

      if (this.isShowing()) {
        this.dismiss();
      }
    });

    return iconButton;
  }

  public ArrayList<IconButtonView> getButtons() {
    return buttons;
  }
}
