package com.zoyi.channel.plugin.android.activity.chat.model;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.type.ContentType;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.enumerate.SendingState;
import com.zoyi.channel.plugin.android.global.Const;

public class SendFileItem extends SendItem {

  @NonNull
  private Uri uri;

  @Nullable
  private String name;

  private long size;

  public SendFileItem(@Nullable String chatId, int index, @NonNull Uri uri, @Nullable String name, long size) {
    super(chatId, index);

    this.uri = uri;
    this.name = name;
    this.size = size;
  }

  @NonNull
  public Uri getUri() {
    return uri;
  }

  @Nullable
  public String getName() {
    return name;
  }

  public long getSize() {
    return size;
  }

  @Override
  public ContentType getContentType() {
    return ContentType.FILE;
  }

  @Override
  public MessageType getType() {
    if (state == SendingState.FAIL) {
      return MessageType.FAILED_FILE;
    }
    return MessageType.SENDING_FILE;
  }

  @Override
  public Long getPrimaryKey() {
    if (state == SendingState.FAIL) {
      return Const.FAILED_FILE_PRIMARY_KEY;
    }
    return Const.SENDING_FILE_PRIMARY_KEY;
  }

  @Override
  public String getSecondaryKey() {
    if (state == SendingState.FAIL) {
      return requestId;
    }
    return "";
  }

  @Override
  public boolean shouldShowTempMessage() {
    return false;
  }
}
