/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.toast;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.TimeUtils;

public class DateToastView
extends FrameLayout {
    private TextView dateToast;

    public DateToastView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public DateToastView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public DateToastView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        View root = LayoutInflater.from((Context)context).inflate(R.layout.ch_view_date_toast, (ViewGroup)this, true);
        this.dateToast = (TextView)root.findViewById(R.id.ch_textDateToast);
    }

    public void show(@Nullable Long timestamp) {
        if (timestamp == null) {
            return;
        }
        if (this.dateToast != null) {
            this.dateToast.setText((CharSequence)TimeUtils.formatTranslatedDate(timestamp, (Language)((Object)SettingsStore.get().language.get())));
            this.clearAnimation();
            AlphaAnimation animation = new AlphaAnimation(1.0f, 0.0f);
            animation.setInterpolator((Interpolator)new LinearInterpolator());
            animation.setStartOffset(1500L);
            animation.setDuration(200L);
            this.setAnimation((Animation)animation);
        }
    }
}

