/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.MarketingAction;
import com.zoyi.channel.plugin.android.action.UserAction;
import com.zoyi.channel.plugin.android.enumerate.ButtonTheme;
import com.zoyi.channel.plugin.android.enumerate.LinkType;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.entity.Previewable;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Button;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.selector.ProfileSelector;
import com.zoyi.channel.plugin.android.store.PopupStore;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.util.AlarmCenter;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.UriUtils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.layout.message.TextMessageView;
import com.zoyi.channel.plugin.android.view.listener.OnPopupClickListener;
import com.zoyi.channel.plugin.android.view.media_thumbnail.AbsPopUpMediaThumbnailView;
import com.zoyi.channel.plugin.android.view.popup.PopupLinkButtonView;
import com.zoyi.channel.plugin.android.view.textview.FileRowTextView;
import com.zoyi.com.annimon.stream.Stream;
import java.util.List;

public abstract class BasePopupView
extends LinearLayout {
    protected Context context;
    protected View root;
    protected View itemRoot;
    protected View buttonPopupClose;
    protected AvatarLayout avatarPopup;
    protected TextView textPopupName;
    protected TextView textPopupTime;
    protected TextMessageView viewPopupMessage;
    protected AbsPopUpMediaThumbnailView viewPopUpMedia;
    private View imagePopUpImageMultiple;
    protected FileRowTextView viewFileRow;
    protected LinearLayout layoutLinkButton;
    @Nullable
    protected OnPopupClickListener onPopupClickListener;
    @Nullable
    protected Binder binder;
    @Nullable
    protected Message item;

    public BasePopupView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public BasePopupView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public BasePopupView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    protected abstract int getLayoutId();

    @Initializer
    protected void init(Context context) {
        this.context = context;
        this.root = LayoutInflater.from((Context)context).inflate(this.getLayoutId(), (ViewGroup)this, true);
        this.root.setVisibility(8);
        this.itemRoot = this.root.findViewById(R.id.ch_rootPopUp);
        this.itemRoot.setOnClickListener(v -> this.onClickPopup());
        this.avatarPopup = (AvatarLayout)this.root.findViewById(R.id.ch_avatarPopUp);
        this.textPopupName = (TextView)this.root.findViewById(R.id.ch_textPopUpName);
        this.textPopupTime = (TextView)this.root.findViewById(R.id.ch_textPopUpTime);
        this.viewPopupMessage = (TextMessageView)this.root.findViewById(R.id.ch_viewPopUpMessage);
        this.viewFileRow = (FileRowTextView)this.root.findViewById(R.id.ch_textPopUpFileName);
        this.viewPopUpMedia = (AbsPopUpMediaThumbnailView)this.root.findViewById(R.id.ch_viewPopUpMedia);
        this.viewPopUpMedia.setOnPopupClickListener(v -> this.onClickPopup());
        this.imagePopUpImageMultiple = this.root.findViewById(R.id.ch_imagePopUpImageMultiple);
        this.buttonPopupClose = this.root.findViewById(R.id.ch_buttonPopUpClose);
        this.buttonPopupClose.setOnClickListener(v -> {
            PopupStore.get().popupMessage.set(null);
            UserAction.closePopUp();
        });
        this.layoutLinkButton = (LinearLayout)this.root.findViewById(R.id.ch_layoutPopUpLinkButtons);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.binder != null) {
            this.binder.unbind();
        }
    }

    protected void bindProfileData(String personType, String personId) {
        ProfileEntity person = ProfileSelector.getProfile(personType, personId);
        this.avatarPopup.setVisibility(0);
        this.avatarPopup.set(person);
        this.textPopupName.setText((CharSequence)(person != null ? person.getName() : ResUtils.getUnknown()));
    }

    public void setPopupClickListener(OnPopupClickListener onPopupClickListener) {
        this.onPopupClickListener = onPopupClickListener;
    }

    public void show(Message message) {
        this.resetView();
        this.item = message;
        this.bindProfileData(message.getPersonType(), message.getPersonId());
        this.bindContent(message);
        if (PrefSupervisor.isEnabledPopupAlarm(this.context)) {
            AlarmCenter.alarm(this.context);
        }
        this.root.setVisibility(0);
    }

    protected void bindContent(Message message) {
        List<Button> buttons;
        File file;
        this.viewFileRow.setVisibility(8);
        this.viewPopupMessage.setVisibility(8);
        this.viewPopUpMedia.setVisibility(8);
        this.imagePopUpImageMultiple.setVisibility(8);
        this.layoutLinkButton.setVisibility(8);
        this.textPopupTime.setText((CharSequence)TimeUtils.getTime(message.getCreatedAt()));
        if (message.getBlocks() != null && !message.getBlocks().isEmpty()) {
            this.viewPopupMessage.setVisibility(0);
            this.viewPopupMessage.setMaxLines(message.containsPreviewableFile() || message.getWebPage() != null ? this.getAttachmentTextMaxLine() : this.getDefaultTextMaxLine());
            this.viewPopupMessage.setBlocks(message.getBlocks());
        }
        if (message.getWebPage() != null) {
            this.bindWebPage(message.getId(), message.getWebPage());
        }
        if ((file = message.getPrimaryFile()) != null && file.isPreviewable() && message.getWebPage() == null) {
            this.bindMedia(message, file);
        }
        if ((buttons = message.getButtons()) != null && buttons.size() > 0) {
            Stream.of(buttons).forEach(button -> {
                PopupLinkButtonView linkButtonView = new PopupLinkButtonView(this.getContext());
                linkButtonView.setText(button.getTitle());
                if (button.getTheme() != null) {
                    linkButtonView.setPopupTheme(ButtonTheme.fromString(button.getTheme()));
                }
                linkButtonView.setOnClickListener(v -> this.onClickLinkButton(button.getUrl()));
                try {
                    LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
                    lp.weight = 1.0f;
                    this.layoutLinkButton.addView((View)linkButtonView, (ViewGroup.LayoutParams)lp);
                }
                catch (Exception e) {
                    this.layoutLinkButton.addView((View)linkButtonView);
                }
            });
            this.layoutLinkButton.setVisibility(0);
        }
    }

    private void bindMedia(Message message, File file) {
        this.setMediaSize(file);
        if (Stream.ofNullable(message.getFiles()).filter(File::isPreviewable).toList().size() > 1) {
            this.imagePopUpImageMultiple.setVisibility(0);
        }
        this.viewPopUpMedia.setVisibility(0);
        this.viewPopUpMedia.setAttachment(message.getId(), file);
    }

    private void bindWebPage(String messageId, WebPage webPage) {
        if (webPage.getPreviewUrl() != null) {
            this.setMediaSize(webPage);
            this.viewPopUpMedia.setVisibility(0);
            this.viewPopUpMedia.setWebPage(messageId, webPage);
        }
    }

    protected abstract void setMediaSize(Previewable var1);

    private void hide() {
        this.resetView();
    }

    public void resetView() {
        this.item = null;
        this.root.setVisibility(8);
        this.viewPopUpMedia.clear();
        if (this.viewPopupMessage != null) {
            this.viewPopupMessage.setText("");
        }
        if (this.layoutLinkButton != null) {
            this.layoutLinkButton.removeAllViews();
        }
    }

    private void onClickPopup() {
        if (this.item != null && this.item.getChatId() != null && this.onPopupClickListener != null) {
            this.onPopupClickListener.onPopupClick(this.item.getChatId());
        }
        this.hide();
    }

    private void onClickLinkButton(String link) {
        if (this.context != null) {
            if (UriUtils.isMailToUri(link)) {
                Executor.openEmail(this.context, link.substring("mailto:".length()));
            } else if (UriUtils.isTelUri(link)) {
                Executor.openCall(this.context, link.substring("tel:".length()));
            } else {
                Executor.executeLinkAction(this.context, link, LinkType.URL);
            }
            if (this.item != null && this.item.getMarketing() != null) {
                MarketingAction.sendClickEvent(this.item.getMarketing(), link);
            }
        }
        UserAction.closePopUp();
        this.hide();
    }

    protected abstract int getDefaultTextMaxLine();

    protected abstract int getAttachmentTextMaxLine();
}

