/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileBotSubmitListener;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnProfileUpdateRequestListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.view.profilebot.BaseProfileBotInputView;
import com.zoyi.channel.plugin.android.activity.chat.view.profilebot.ProfileBotInputBooleanView;
import com.zoyi.channel.plugin.android.activity.chat.view.profilebot.ProfileBotInputDateView;
import com.zoyi.channel.plugin.android.activity.chat.view.profilebot.ProfileBotInputMobileNumberView;
import com.zoyi.channel.plugin.android.activity.chat.view.profilebot.ProfileBotInputNumberView;
import com.zoyi.channel.plugin.android.activity.chat.view.profilebot.ProfileBotInputStringView;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.ProfileBotCompleteView;
import com.zoyi.channel.plugin.android.base.adapter.BaseViewHolder;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.ProfileBot;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.store.PluginStore;
import com.zoyi.channel.plugin.android.store.ProfileBotStore;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import java.util.Locale;

public class ProfileBotMessageHolder
extends BaseViewHolder
implements OnProfileBotSubmitListener {
    private LinearLayout layoutCompleteItems;
    private View layoutProfileBotInput;
    private TextView textInputName;
    private TextView textInputProgressPage;
    private TextView textInputProgressTotalPages;
    private TextView textInputError;
    private ProfileBotInputBooleanView inputBooleanView;
    private ProfileBotInputDateView inputDateView;
    private ProfileBotInputMobileNumberView inputMobileNumberView;
    private ProfileBotInputNumberView inputNumberView;
    private ProfileBotInputStringView inputStringView;
    @Nullable
    private BaseProfileBotInputView inputView;
    private TextView textTerms;
    @Nullable
    private ProfileBotMessageItem item;
    @Nullable
    private OnProfileUpdateRequestListener listener;

    public ProfileBotMessageHolder(@NonNull View itemView, @Nullable OnProfileUpdateRequestListener listener) {
        super(itemView);
        this.listener = listener;
        this.layoutCompleteItems = (LinearLayout)itemView.findViewById(R.id.ch_layoutProfileBotItemCompleteItems);
        this.layoutProfileBotInput = itemView.findViewById(R.id.ch_layoutProfileBotItemInput);
        this.textInputName = (TextView)itemView.findViewById(R.id.ch_textProfileBotItemLabel);
        this.textInputProgressPage = (TextView)itemView.findViewById(R.id.ch_textProfileBotItemPage);
        this.textInputProgressTotalPages = (TextView)itemView.findViewById(R.id.ch_textProfileBotItemTotalPages);
        this.textInputError = (TextView)itemView.findViewById(R.id.ch_textProfileBotInputError);
        this.inputBooleanView = (ProfileBotInputBooleanView)itemView.findViewById(R.id.ch_viewProfileBotInputBoolean);
        this.inputBooleanView.setListener(this);
        this.inputDateView = (ProfileBotInputDateView)itemView.findViewById(R.id.ch_viewProfileBotInputDate);
        this.inputDateView.setListener(this);
        this.inputMobileNumberView = (ProfileBotInputMobileNumberView)itemView.findViewById(R.id.ch_viewProfileBotInputMobileNumber);
        this.inputMobileNumberView.setListener(this);
        this.inputNumberView = (ProfileBotInputNumberView)itemView.findViewById(R.id.ch_viewProfileBotInputNumber);
        this.inputNumberView.setListener(this);
        this.inputStringView = (ProfileBotInputStringView)itemView.findViewById(R.id.ch_viewProfileBotInputString);
        this.inputStringView.setListener(this);
        this.textTerms = (TextView)itemView.findViewById(R.id.ch_textProfileBotItemTerms);
        this.textTerms.setText((CharSequence)Utils.getHtmlFormattedText(ResUtils.getString("ch.agreement")));
        this.textTerms.setOnClickListener(v -> {
            Plugin plugin = PluginStore.get().pluginState.get();
            Language language = (Language)((Object)((Object)SettingsStore.get().language.get()));
            if (plugin != null && plugin.getKey() != null) {
                IntentUtils.setUrl(itemView.getContext(), String.format("https://channel.io/%s/terms_user?plugin_key=%s", language.toString(), plugin.getKey())).startActivity();
            } else {
                IntentUtils.setUrl(itemView.getContext(), String.format("https://channel.io/%s/terms_user", language.toString())).startActivity();
            }
        });
    }

    public void bind(ProfileBotMessageItem item) {
        this.item = item;
        if (item == null) {
            return;
        }
        ProfileBot inputProfileBot = null;
        int inputPageIndex = -1;
        for (int i = 0; i < item.getProfileBots().size(); ++i) {
            ProfileBot profileBot = item.getProfileBots().get(i);
            if (profileBot == null || profileBot.getKey() == null) continue;
            if (profileBot.getValue() != null) {
                Object view;
                if (i < this.layoutCompleteItems.getChildCount()) {
                    view = this.layoutCompleteItems.getChildAt(i);
                    if (!(view instanceof ProfileBotCompleteView)) continue;
                    view.setVisibility(0);
                    ((ProfileBotCompleteView)((Object)view)).bind(profileBot);
                    continue;
                }
                view = new ProfileBotCompleteView(this.itemView.getContext());
                ((ProfileBotCompleteView)((Object)view)).bind(profileBot);
                this.layoutCompleteItems.addView((View)view);
                continue;
            }
            inputProfileBot = profileBot;
            inputPageIndex = i;
            int index = i;
            while (i < this.layoutCompleteItems.getChildCount()) {
                this.layoutCompleteItems.getChildAt(index).setVisibility(8);
                ++i;
            }
            break;
        }
        this.textTerms.setVisibility(inputPageIndex == 0 ? 0 : 8);
        if (inputProfileBot != null) {
            this.layoutProfileBotInput.setVisibility(0);
            this.textInputName.setText((CharSequence)inputProfileBot.getName());
            this.textInputProgressPage.setText((CharSequence)String.valueOf(inputPageIndex + 1));
            this.textInputProgressTotalPages.setText((CharSequence)String.format(Locale.US, "/%d", item.getProfileBots().size()));
            String prevKey = ProfileBotStore.get().inputKey.get();
            boolean isRestored = prevKey != null && prevKey.equals(inputProfileBot.getKey());
            boolean requestFocus = isRestored ? ProfileBotStore.get().requestFocus.get() : true;
            Object restoreValue = isRestored ? ProfileBotStore.get().inputValue.get() : null;
            FetchState fetchState = isRestored ? (FetchState)((Object)ProfileBotStore.get().requestState.get()) : FetchState.COMPLETE;
            String inputError = isRestored && fetchState == FetchState.FAILED ? ProfileBotStore.get().inputError.get() : null;
            this.inputBooleanView.setVisibility(8);
            this.inputDateView.setVisibility(8);
            this.inputMobileNumberView.setVisibility(8);
            this.inputNumberView.setVisibility(8);
            this.inputStringView.setVisibility(8);
            if (inputError != null) {
                this.textInputError.setVisibility(0);
                this.textInputError.setText((CharSequence)inputError);
            } else {
                this.textInputError.setVisibility(8);
            }
            if ("mobileNumber".equals(inputProfileBot.getKey())) {
                this.bindInputView(this.inputMobileNumberView, inputProfileBot.getKey(), restoreValue, requestFocus, fetchState);
            } else {
                String type;
                switch (type = inputProfileBot.getType() != null ? inputProfileBot.getType() : "") {
                    case "boolean": {
                        this.bindInputView(this.inputBooleanView, inputProfileBot.getKey(), restoreValue, requestFocus, fetchState);
                        break;
                    }
                    case "date": {
                        this.bindInputView(this.inputDateView, inputProfileBot.getKey(), restoreValue, requestFocus, fetchState);
                        break;
                    }
                    case "number": {
                        this.bindInputView(this.inputNumberView, inputProfileBot.getKey(), restoreValue, requestFocus, fetchState);
                        break;
                    }
                    default: {
                        this.bindInputView(this.inputStringView, inputProfileBot.getKey(), restoreValue, requestFocus, fetchState);
                    }
                }
            }
        } else {
            this.inputView = null;
            this.layoutProfileBotInput.setVisibility(8);
            ProfileBotStore.get().requestFocus.set(false);
        }
    }

    private void bindInputView(BaseProfileBotInputView inputView, String key, @Nullable Object value, boolean requestFocus, FetchState fetchState) {
        this.inputView = inputView;
        inputView.setVisibility(0);
        inputView.setValue(key, value, fetchState);
        if (requestFocus) {
            inputView.focus();
        }
    }

    @Override
    public void onSubmit(String key, @Nullable Object value) {
        if (this.item != null && this.listener != null) {
            this.listener.onProfileRequest(this.item, key, value);
        }
    }

    @Override
    public void onRecycled() {
        super.onRecycled();
        if (this.inputView != null) {
            this.inputView.onRecycled();
            this.inputView = null;
        }
    }

    public static ProfileBotMessageHolder newInstance(ViewGroup parent, @Nullable OnProfileUpdateRequestListener listener) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        return new ProfileBotMessageHolder(inflater.inflate(R.layout.ch_plugin_item_message_profile_bot, parent, false), listener);
    }
}

