/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.app.Dialog;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageActionListener;
import com.zoyi.channel.plugin.android.activity.chat.model.ChatMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.AbsHostMessageHolder;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Marketing;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.MessageAction;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.com.annimon.stream.Optional;

public class HostMessageHolder
extends AbsHostMessageHolder {
    @Nullable
    private Message message;
    @Nullable
    private OnMessageActionListener listener;

    private HostMessageHolder(View itemView, @Nullable OnMessageActionListener listener) {
        super(itemView, listener);
        this.listener = listener;
    }

    public void bind(ChatMessageItem item, boolean showDate, boolean isHead, boolean isTail, boolean isLast) {
        super.bind(item.getMessage(), item.getCreatedAt(), showDate, isHead, isTail);
        this.message = item.getMessage();
        String messageId = (String)Optional.ofNullable((Object)item.getMessage()).map(Message::getId).orElse(null);
        Message message = item.getMessage();
        if (message != null) {
            if (message.isDeleted()) {
                this.setDeleteMessage();
            } else {
                this.setBlockMessage(message);
                if (message.getButtons() != null) {
                    this.setLinkButtons(message.getButtons());
                }
                Optional.ofNullable((Object)message.getWebPage()).ifPresent(webPage -> this.setWebPage(messageId, (WebPage)webPage));
                MessageAction action = message.getAction();
                if (isLast && action != null) {
                    this.setActionButtons(action.getType(), action.getButtons());
                } else {
                    this.setActionButtons(null, null);
                }
                this.setAttachments(message.getId(), message.getFiles(), this);
                this.setReactions(message.getReactions());
            }
        }
    }

    private void setBlockMessage(Message message) {
        if (message.getLanguage() != null && !message.getLanguage().equals(((Language)((Object)SettingsStore.get().language.get())).toString()) && SettingsStore.get().showTranslation.get().booleanValue()) {
            this.setTranslation(message.getChatId(), message.getId(), ((Language)((Object)SettingsStore.get().language.get())).toString(), message.getBlocks());
        } else {
            this.setBlocks(message.getBlocks());
        }
    }

    public static HostMessageHolder newInstance(ViewGroup parent, @Nullable OnMessageActionListener listener) {
        return new HostMessageHolder(HostMessageHolder.getItemView(parent), listener);
    }

    @Override
    public boolean onLongClick(View v) {
        Dialog dialog;
        if (this.listener != null && this.message != null && (dialog = this.listener.onMessageLongClick(this.message)) != null) {
            dialog.show();
            return true;
        }
        return false;
    }

    @Override
    public void onWebPageLongClick() {
        Dialog dialog;
        if (this.listener != null && this.message != null && (dialog = this.listener.onMessageLongClick(this.message)) != null) {
            dialog.show();
        }
    }

    @Override
    public void onAttachmentClick(File attachment) {
        super.onAttachmentClick(attachment);
        if (this.listener != null && this.message != null) {
            this.listener.onAttachmentClick(attachment, this.message);
        }
    }

    @Override
    public void onAttachmentLongClick() {
        Dialog dialog;
        if (this.listener != null && this.message != null && (dialog = this.listener.onMessageLongClick(this.message)) != null) {
            dialog.show();
        }
    }

    @Override
    public void onLinkButtonLongClick() {
        Dialog dialog;
        if (this.listener != null && this.message != null && (dialog = this.listener.onMessageLongClick(this.message)) != null) {
            dialog.show();
        }
    }

    @Override
    protected void onReactionsLongClicked() {
        if (this.listener != null && this.message != null && this.message.getReactions() != null && this.message.getReactions().size() > 0) {
            this.listener.onReactionsLongClicked(this.message.getReactions());
        }
    }

    @Override
    @Nullable
    protected Marketing getMarketing() {
        return (Marketing)Optional.ofNullable((Object)this.message).map(Message::getMarketing).orElse(null);
    }

    @Override
    protected void clear() {
        super.clear();
        this.message = null;
    }
}

