/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.model.ConnectableMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.MessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.Initializer;

public class ChatMessageItem
extends ConnectableMessageItem
implements MessageItem {
    private Message message;

    @Initializer
    public ChatMessageItem(Message message) {
        this.message = message;
    }

    @Override
    public Long getPrimaryKey() {
        return this.message != null ? this.message.getCreatedAt() : 0L;
    }

    @Override
    public String getSecondaryKey() {
        return this.message != null ? this.message.getId() : "";
    }

    public Message getMessage() {
        return this.message;
    }

    @Override
    public MessageType getType() {
        switch (this.message != null && this.message.getPersonType() != null ? this.message.getPersonType() : "") {
            case "manager": 
            case "bot": {
                return MessageType.HOST;
            }
            case "user": {
                return MessageType.USER;
            }
        }
        return MessageType.UNKNOWN;
    }

    @Nullable
    public String getPersonType() {
        return this.message != null ? this.message.getPersonType() : null;
    }

    @Nullable
    public String getPersonId() {
        return this.message != null ? this.message.getPersonId() : null;
    }

    @Override
    public Long getCreatedAt() {
        return this.message != null ? this.message.getCreatedAt() : 0L;
    }

    @Override
    public boolean isSamePerson(@Nullable Object item) {
        if (item instanceof ChatMessageItem) {
            ChatMessageItem chatItem = (ChatMessageItem)item;
            return CompareUtils.isSame(this.getPersonType(), chatItem.getPersonType()) && CompareUtils.isSame(this.getPersonId(), chatItem.getPersonId());
        }
        if (item instanceof SendItem) {
            return CompareUtils.isSame("user", this.getPersonType());
        }
        return false;
    }
}

