/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.common.userchat.viewholder;

import android.content.Context;
import android.support.annotation.ColorRes;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.common.userchat.listener.OnChatClickListener;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.textview.CHTextView;
import com.zoyi.channel.plugin.android.view.textview.FileRowTextView;

public class ChatHolder
extends RecyclerView.ViewHolder
implements View.OnClickListener,
View.OnLongClickListener {
    @Nullable
    private OnChatClickListener listener;
    @Nullable
    private ChatItem chatItem;
    private AvatarLayout avatar;
    private CHTextView textName;
    private CHTextView textMessage;
    private FileRowTextView viewFileRow;
    private CHTextView textTime;
    private CHTextView textBadge;

    @Initializer
    public ChatHolder(View itemView, @Nullable OnChatClickListener listener) {
        super(itemView);
        this.listener = listener;
        this.avatar = (AvatarLayout)itemView.findViewById(R.id.ch_avatarSingle);
        this.textName = (CHTextView)itemView.findViewById(R.id.ch_textUserChatName);
        this.textMessage = (CHTextView)itemView.findViewById(R.id.ch_textUserChatMessage);
        this.viewFileRow = (FileRowTextView)itemView.findViewById(R.id.ch_viewFileRow);
        this.textTime = (CHTextView)itemView.findViewById(R.id.ch_textUserChatTime);
        this.textBadge = (CHTextView)itemView.findViewById(R.id.ch_textUserChatBadge);
        itemView.setOnClickListener((View.OnClickListener)this);
        itemView.setOnLongClickListener((View.OnLongClickListener)this);
    }

    public void bind(ChatItem chatItem) {
        this.chatItem = chatItem;
        this.avatar.set(chatItem.getProfile());
        this.textName.setText(chatItem.getProfile() != null ? chatItem.getProfile().getName() : "");
        int alert = chatItem.getAlert();
        Views.setVisibility((View)this.textBadge, alert > 0, 4);
        this.textBadge.setText(Utils.getCount(alert, true));
        this.textTime.setText(TimeUtils.get(chatItem.getUpdatedAt()));
        this.textMessage.setVisibility(8);
        this.viewFileRow.setVisibility(8);
        if (chatItem.isDelete()) {
            this.textMessage.setVisibility(0);
            this.setKeyMessage("ch.message_stream.message.deleted_message", R.color.ch_grey900, 2);
        } else if (chatItem.hasReview()) {
            this.textMessage.setVisibility(0);
            this.setKeyMessage("ch.review.complete.preview", R.color.ch_grey500, 2);
        } else if (chatItem.requestReview()) {
            this.textMessage.setVisibility(0);
            this.setKeyMessage("ch.review.require.preview", R.color.ch_grey500, 2);
        } else if (chatItem.isClosed()) {
            this.textMessage.setVisibility(0);
            this.setKeyMessage("ch.review.complete.title", R.color.ch_grey500, 2);
        } else if (chatItem.getFiles().size() > 0) {
            if (chatItem.getPlainText() != null) {
                this.textMessage.setVisibility(0);
                this.setMessage(chatItem.getPlainText(), R.color.ch_grey900, 1);
            }
            this.viewFileRow.setVisibility(0);
            this.viewFileRow.setFile(chatItem.getFiles().get(0), chatItem.getFiles().size());
        } else if (chatItem.getPlainText() != null) {
            this.textMessage.setVisibility(0);
            this.setMessage(chatItem.getPlainText(), R.color.ch_grey900, 2);
        }
    }

    private void setKeyMessage(@Nullable String textKey, @ColorRes int colorId, int maxLines) {
        this.setMessage(ResUtils.getString(textKey), colorId, maxLines);
    }

    private void setMessage(@Nullable String text, @ColorRes int colorId, int maxLines) {
        this.textMessage.setText(text);
        this.textMessage.setTextColor(ContextCompat.getColor((Context)this.itemView.getContext(), (int)colorId));
        this.textMessage.setMaxLines(maxLines);
    }

    public void onClick(View v) {
        if (this.listener != null && this.chatItem != null) {
            this.listener.onChatItemClick(this.chatItem);
        }
    }

    public boolean onLongClick(View v) {
        if (this.listener != null && this.chatItem != null) {
            this.listener.onChatItemLongClick(this.chatItem);
        }
        return true;
    }

    public static ChatHolder newInstance(ViewGroup parent, @Nullable OnChatClickListener listener) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        View itemView = inflater.inflate(R.layout.ch_plugin_item_chat, parent, false);
        return new ChatHolder(itemView, listener);
    }
}

