/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.viewholder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.MessageContentView;
import com.zoyi.channel.plugin.android.model.rest.Reaction;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.com.annimon.stream.Collectors;
import com.zoyi.com.annimon.stream.Stream;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;
import java.util.List;

public class ReactionsView
extends FrameLayout
implements MessageContentView {
    private Context context;
    private AppCompatImageView reactionView1;
    private AppCompatImageView reactionView2;
    private AppCompatImageView reactionView3;
    private TextView textCount;

    public ReactionsView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public ReactionsView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ReactionsView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.ch_holder_message_content_reactions, (ViewGroup)this);
        this.context = context;
        this.reactionView1 = (AppCompatImageView)this.findViewById(R.id.ch_imageMessageReaction1);
        this.reactionView2 = (AppCompatImageView)this.findViewById(R.id.ch_imageMessageReaction2);
        this.reactionView3 = (AppCompatImageView)this.findViewById(R.id.ch_imageMessageReaction3);
        this.textCount = (TextView)this.findViewById(R.id.ch_textMessageReactionsCount);
    }

    public void setReactions(@NonNull List<Reaction> reactions) {
        this.setReactionEmoji(this.reactionView1, reactions.size() >= 1 ? reactions.get(0) : null);
        this.setReactionEmoji(this.reactionView2, reactions.size() >= 2 ? reactions.get(1) : null);
        this.setReactionEmoji(this.reactionView3, reactions.size() >= 3 ? reactions.get(2) : null);
        this.textCount.setText((CharSequence)Utils.getCount((Integer)Stream.ofNullable(reactions).map(Reaction::getCount).collect(Collectors.summingInt(Integer::intValue)), false));
    }

    private void setReactionEmoji(AppCompatImageView reactionView, @Nullable Reaction reaction) {
        if (reaction != null && reaction.getEmojiName() != null) {
            reactionView.setVisibility(0);
            Glide.with((Context)this.context).load(String.format("https://cf.channel.io/asset/emoji/images/44/%s.png", reaction.getEmojiName())).centerCrop().dontAnimate().diskCacheStrategy(DiskCacheStrategy.SOURCE).into((ImageView)reactionView);
        } else {
            reactionView.setVisibility(8);
        }
    }

    @Override
    public void resetView() {
    }

    @Override
    public void clear() {
    }
}

