/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.action;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.activity.chat.model.SendActionItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendFileItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendTextItem;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.repo.MessageRepo;
import com.zoyi.channel.plugin.android.model.repo.MessagesRepo;
import com.zoyi.channel.plugin.android.model.repo.UserChatRepo;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.network.ProgressRequestBody;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.store.PopupStore;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.functions.Action0;
import com.zoyi.rx.functions.Action1;
import java.util.HashMap;

public class ChatAction {
    public static void createUserChat(@Nullable String pluginId, String url, RestSubscriber<UserChatRepo> subscriber) {
        if (pluginId != null) {
            Api.createUserChat(pluginId, url).runBy(ActionType.CREATE_USER_CHAT).cancelBy(ActionType.SHUTDOWN).run(subscriber);
        }
    }

    public static void removeUserChat(@Nullable String chatId, final Action1<UserChatRepo> onSuccess, final Action0 onFail) {
        if (chatId != null) {
            Api.removeUserChat(chatId).cancelBy(ActionType.SHUTDOWN).run(new RestSubscriber<UserChatRepo>(){

                @Override
                public void onError(RetrofitException error) {
                    onFail.call();
                }

                @Override
                public void onSuccess(@NonNull UserChatRepo userChatRepo) {
                    onSuccess.call((Object)userChatRepo);
                }
            });
        } else {
            onFail.call();
        }
    }

    public static void fetchUserChat(@Nullable String chatId, RestSubscriber<UserChatRepo> repo) {
        if (chatId != null) {
            Api.getUserChat(chatId).runBy(ActionType.FETCH_USER_CHAT).cancelBy(ActionType.SOCKET_DISCONNECTED, ActionType.CHAT_CLOSED, ActionType.SHUTDOWN).run(repo);
        }
    }

    public static void fetchPopUpChat(@Nullable String chatId) {
        if (chatId != null) {
            Api.getUserChat(chatId).runBy(ActionType.FETCH_LAST_CHAT).cancelBy(ActionType.SHUTDOWN).run(new RestSubscriber<UserChatRepo>(){

                @Override
                public void onSuccess(@NonNull UserChatRepo repo) {
                    Activity topActivity = GlobalStore.get().topActivity.get();
                    if (repo.getMessage() != null && !repo.getMessage().isDeleted() && !ChannelUtils.isChannelPluginActivity((Context)topActivity)) {
                        PopupStore.get().popupMessage.set(repo.getMessage());
                    }
                }
            });
        }
    }

    public static void fetchMessages(@Nullable String chatId, RestSubscriber<MessagesRepo> repo) {
        if (chatId != null) {
            Api.getMessages(chatId, null, 30, "DESC").runBy(ActionType.FETCH_MESSAGES).cancelBy(ActionType.SOCKET_DISCONNECTED, ActionType.CHAT_CLOSED, ActionType.SHUTDOWN).run(repo);
        }
    }

    public static void fetchBackwardMessages(@Nullable String chatId, String since, RestSubscriber<MessagesRepo> repo) {
        if (chatId != null) {
            Api.getMessages(chatId, since, 30, "DESC").runBy(ActionType.FETCH_BACKWARD_MESSAGES).cancelBy(ActionType.FETCH_MESSAGES, ActionType.CHAT_CLOSED, ActionType.SOCKET_DISCONNECTED, ActionType.SHUTDOWN).run(repo);
        }
    }

    public static void sendTextMessage(@Nullable String chatId, SendTextItem item, RestSubscriber<MessageRepo> subscriber) {
        if (chatId != null && item != null) {
            RequestBody body = RequestUtils.form().set("plainText", item.getText()).set("requestId", item.getRequestId()).create();
            Api.sendMessage(chatId, body).cancelBy(ActionType.SHUTDOWN).run(subscriber);
        }
    }

    @Nullable
    public static Subscription sendFileMessage(@Nullable String chatId, SendFileItem item, Action1<Integer> progressAction, RestSubscriber<MessageRepo> subscriber) {
        String channelId = (String)Optional.ofNullable((Object)ChannelStore.get().channelState.get()).map(Channel::getId).orElse(null);
        if (channelId != null && chatId != null && item != null) {
            ProgressRequestBody progressRequestBody = new ProgressRequestBody(item.getUri(), item.getName(), item.getSize(), progressAction);
            return Api.uploadFile(channelId, chatId, item.getRequestId(), progressRequestBody).cancelBy(ActionType.SHUTDOWN).run(subscriber);
        }
        return null;
    }

    public static void closeChat(@Nullable String chatId, SendActionItem item, RestSubscriber<MessageRepo> subscriber) {
        ActionButton actionButton = item.getActionButton();
        if (chatId != null && actionButton != null) {
            Api.closeUserChat(chatId, actionButton.getMessage().getId(), item.getRequestId()).cancelBy(ActionType.SHUTDOWN).run(subscriber);
        }
    }

    public static void reviewChat(@Nullable String chatId, String review, SendActionItem item, RestSubscriber<MessageRepo> subscriber) {
        ActionButton actionButton = item.getActionButton();
        if (chatId != null && actionButton != null) {
            Api.reviewUserChat(chatId, actionButton.getMessage().getId(), item.getRequestId(), review).cancelBy(ActionType.SHUTDOWN).run(subscriber);
        }
    }

    public static void selectForm(@Nullable String chatId, SendActionItem item, RestSubscriber<MessageRepo> subscriber) {
        ActionButton actionButton = item.getActionButton();
        if (chatId != null && actionButton != null) {
            HashMap<String, String> submit = new HashMap<String, String>();
            submit.put("id", actionButton.getMessage().getId());
            submit.put("key", actionButton.getKey());
            RequestBody body = RequestUtils.form().set("plainText", item.getText()).set("requestId", item.getRequestId()).set("submit", submit).create();
            Api.sendMessage(chatId, body).cancelBy(ActionType.SHUTDOWN).run(subscriber);
        }
    }

    public static void selectSupportBotStep(@Nullable String chatId, SendActionItem item, RestSubscriber<MessageRepo> subscriber) {
        ActionButton actionButton = item.getActionButton();
        if (chatId != null && actionButton != null) {
            Api.submitButtonAction(chatId, actionButton.getKey(), actionButton.getMessage().getId(), item.getRequestId()).cancelBy(ActionType.SHUTDOWN).run(subscriber);
        }
    }

    public static void read(@Nullable String chatId) {
        if (chatId != null) {
            Api.read(chatId).cancelBy(ActionType.SHUTDOWN).run(new RestSubscriber());
        }
    }
}

