/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.source.photopicker;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.ArrayList;

public class PhotoDataSource {
    public void getPhotoItems(Context context, Subscriber<ArrayList<PhotoItem>> subscriber) {
        Observable.defer(() -> Observable.just(this.getPhotoItems(context))).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(subscriber);
    }

    private ArrayList<PhotoItem> getPhotoItems(Context context) {
        ArrayList<PhotoItem> photoItems = new ArrayList<PhotoItem>();
        String[] projection = new String[]{"_id", "_display_name", "media_type", "_size", "duration"};
        String selection = "media_type=1 OR media_type=3";
        Cursor cursor = context.getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), projection, selection, null, "date_added");
        if (cursor == null) {
            return photoItems;
        }
        if (cursor.moveToLast()) {
            do {
                try {
                    long id2 = cursor.getLong(cursor.getColumnIndex(projection[0]));
                    String name = cursor.getString(cursor.getColumnIndex(projection[1]));
                    int type = cursor.getInt(cursor.getColumnIndex(projection[2]));
                    long size = cursor.getLong(cursor.getColumnIndex(projection[3]));
                    long duration = cursor.getLong(cursor.getColumnIndex(projection[4]));
                    Uri contentUri = Uri.withAppendedPath((Uri)this.getContentUri(type), (String)String.valueOf(id2));
                    if (size <= 0L) continue;
                    photoItems.add(new PhotoItem(id2, name, contentUri, size, duration));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (cursor.moveToPrevious());
        }
        cursor.close();
        return photoItems;
    }

    private Uri getContentUri(int type) {
        switch (type) {
            case 3: {
                return MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
            }
        }
        return MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
    }
}

