/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelLauncherView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.selector.GlobalSelector;
import com.zoyi.channel.plugin.android.selector.InAppPushSelector;
import com.zoyi.channel.plugin.android.store.InAppPushStore;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.listener.OnPushClickListener;
import com.zoyi.channel.plugin.android.view.popup.BubblePushView;
import com.zoyi.channel.plugin.android.view.popup.FullScreenPushView;
import com.zoyi.rx.functions.Action1;

class ChannelView
extends FrameLayout
implements OnPushClickListener {
    private Context context;
    private ChannelLauncherView launcherView;
    private FullScreenPushView viewPushFullScreen;
    private BubblePushView viewPushBubble;
    @Nullable
    private Binder visibilityBinder;
    @Nullable
    private Binder launcherVisibilityBinder;
    @Nullable
    private Binder popupBinder;

    public ChannelView(Context context) {
        super(context);
        this.init(context);
    }

    public ChannelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ChannelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_layout_channel_view, (ViewGroup)this, true);
        this.launcherView = (ChannelLauncherView)view.findViewById(R.id.ch_viewLauncher);
        this.viewPushBubble = (BubblePushView)view.findViewById(R.id.ch_viewPushBubble);
        this.viewPushBubble.setPushClickListener(this);
        this.viewPushFullScreen = (FullScreenPushView)view.findViewById(R.id.ch_viewPushFullScreen);
        this.viewPushFullScreen.setPushClickListener(this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.visibilityBinder = GlobalSelector.bindBootState((Action1<Boolean>)((Action1)booted -> this.setVisibility(booted != false ? 0 : 8)));
        this.launcherVisibilityBinder = GlobalSelector.bindLauncherVisibility((Action1<Boolean>)((Action1)showLauncher -> {
            if (showLauncher.booleanValue()) {
                this.launcherView.show();
            } else {
                this.launcherView.hide();
            }
        }));
        this.popupBinder = InAppPushSelector.bindInAppPush((Action1<Message>)((Action1)message -> {
            if (message != null) {
                if (message.getMarketing() != null && message.getMarketing().isFullScreen()) {
                    this.viewPushBubble.resetView();
                    this.viewPushFullScreen.show((Message)message);
                } else {
                    this.viewPushFullScreen.resetView();
                    this.viewPushBubble.show((Message)message);
                }
            } else {
                this.viewPushFullScreen.resetView();
                this.viewPushBubble.resetView();
            }
        }));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.visibilityBinder != null) {
            this.visibilityBinder.unbind();
        }
        if (this.launcherVisibilityBinder != null) {
            this.launcherVisibilityBinder.unbind();
        }
        if (this.popupBinder != null) {
            this.popupBinder.unbind();
        }
    }

    @Override
    public void onPushClick(@NonNull String chatId) {
        InAppPushStore.get().inAppPushMessage.set(null);
        if (this.context instanceof Activity) {
            ChannelIO.openChat((Activity)this.context, chatId, null);
        }
    }
}

