/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.profilebot;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.CountryAction;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.activity.chat.view.profilebot.BaseProfileBotInputView;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store.CountryStore;
import com.zoyi.channel.plugin.android.store.ProfileBotStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.dialog.CountryCodeDialog;
import com.zoyi.channel.plugin.android.view.layout.ChBorderLayout;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;
import com.zoyi.rx.Subscription;
import java.util.List;
import java.util.Locale;

public class ProfileBotInputMobileNumberView
extends BaseProfileBotInputView {
    private ChBorderLayout borderLayout;
    private View buttonSelectCountry;
    private TextView textSelectedCountry;
    private WatchedEditText editText;
    private View progressView;
    private View buttonSubmit;
    private AppCompatImageView imageSubmit;
    @Nullable
    private Integer countryCode;
    private FetchState fetchState = FetchState.COMPLETE;
    @Nullable
    private Dialog dialog;
    @Nullable
    private Subscription subscription;

    public ProfileBotInputMobileNumberView(@NonNull Context context) {
        super(context);
    }

    public ProfileBotInputMobileNumberView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ProfileBotInputMobileNumberView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    @Initializer
    public void initView(View root) {
        this.borderLayout = (ChBorderLayout)root.findViewById(R.id.ch_rootProfileBotInputMobileNumberView);
        this.buttonSelectCountry = root.findViewById(R.id.ch_buttonProfileBotInputMobileNumberSelectCountry);
        this.textSelectedCountry = (TextView)root.findViewById(R.id.textProfileBotInputMobileNumberSelectCountry);
        this.editText = (WatchedEditText)root.findViewById(R.id.ch_editProfileBotInputMobileNumber);
        this.progressView = root.findViewById(R.id.ch_progressProfileBotInputMobileNumber);
        this.buttonSubmit = root.findViewById(R.id.ch_buttonProfileBotInputMobileNumber);
        this.imageSubmit = (AppCompatImageView)root.findViewById(R.id.ch_imageProfileBotInputMobileNumberSubmit);
        this.editText.setOnFocusChangeListener((v, hasFocus) -> {
            this.resolveBorder(hasFocus);
            ProfileBotStore.get().requestFocus.set(true);
        });
        this.buttonSelectCountry.setOnClickListener(v -> this.requestCountrySelector());
        this.buttonSubmit.setOnClickListener(v -> this.submit());
    }

    @Override
    @Nullable
    public Object getValue() {
        if (this.countryCode != null && !this.editText.getString().isEmpty()) {
            return String.format(Locale.US, "+%d%s", this.countryCode, this.editText.getString());
        }
        return null;
    }

    @Override
    public void restore(@Nullable Object value, FetchState fetchState) {
        this.fetchState = fetchState;
        Views.setVisibility(this.progressView, fetchState == FetchState.LOADING);
        Views.setVisibility(this.buttonSubmit, fetchState != FetchState.LOADING);
        this.editText.setEnabled(fetchState != FetchState.LOADING);
        this.imageSubmit.setColorFilter(ResUtils.getColor(fetchState == FetchState.FAILED ? R.color.ch_orange400 : R.color.ch_cobalt400));
        this.resolveBorder(this.editText.hasFocus());
        MobileNumber mobileNumber = new MobileNumber(value != null ? value.toString() : null);
        this.countryCode = mobileNumber.getCountryCode();
        this.textSelectedCountry.setText((CharSequence)String.format(Locale.US, "+%d", mobileNumber.getCountryCode()));
        this.editText.setText(mobileNumber.getPhoneNumber());
        this.editText.setSelection(this.editText.getString().length());
    }

    private void resolveBorder(boolean hasFocus) {
        if (this.fetchState == FetchState.FAILED) {
            this.borderLayout.setBorderColor(ResUtils.getColor(R.color.ch_orange400));
        } else {
            this.borderLayout.setBorderColor(ResUtils.getColor(hasFocus ? R.color.ch_cobalt400 : R.color.ch_grey300));
        }
    }

    @Override
    public void focus() {
        this.editText.requestFocus();
    }

    @Override
    public int getLayoutId() {
        return R.layout.ch_view_profile_bot_input_mobile_number;
    }

    private void requestCountrySelector() {
        List<Country> countries = CountryStore.get().countries.get();
        if (countries == null) {
            this.showProgress(ResUtils.getString(this.getContext(), "ch.loading_information"));
            this.subscription = CountryAction.fetchCountries(new RestSubscriber<List<Country>>(){

                @Override
                public void onError(RetrofitException error) {
                    ProfileBotInputMobileNumberView.this.hideProgress();
                }

                @Override
                public void onSuccess(@NonNull List<Country> countries) {
                    ProfileBotInputMobileNumberView.this.hideProgress();
                    CountryStore.get().countries.set(countries);
                    if (countries.size() > 0) {
                        ProfileBotInputMobileNumberView.this.openCountrySelector(countries);
                    }
                }
            });
        } else {
            this.openCountrySelector(countries);
        }
    }

    private void openCountrySelector(List<Country> countries) {
        this.dialog = new CountryCodeDialog(this.getContext(), countries, (position, countryCode) -> {
            try {
                this.countryCode = Integer.parseInt(countryCode);
                this.textSelectedCountry.setText((CharSequence)String.format("+%s", countryCode));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).show();
    }

    private void showProgress(String message) {
        if (this.getContext() instanceof BaseActivity2) {
            ((BaseActivity2)this.getContext()).showProgress(message);
        }
    }

    private void hideProgress() {
        if (this.getContext() instanceof BaseActivity2) {
            ((BaseActivity2)this.getContext()).hideProgress();
        }
    }

    @Override
    public void onRecycled() {
        super.onRecycled();
        this.hideProgress();
        if (this.dialog != null && this.dialog.isShowing()) {
            this.dialog.dismiss();
            this.dialog = null;
        }
        if (this.subscription != null && !this.subscription.isUnsubscribed()) {
            this.subscription.unsubscribe();
            this.subscription = null;
        }
    }
}

