/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.open.option.ChannelButtonOption;
import com.zoyi.channel.plugin.android.selector.GlobalSelector;
import com.zoyi.channel.plugin.android.selector.SettingsSelector;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.util.UIUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.external.fab.FloatingActionButton;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action3;

public class ChannelLauncherView
extends FrameLayout {
    public static final int BOTTOM_LEFT = 0;
    public static final int BOTTOM_RIGHT = 1;
    private Context context;
    private FloatingActionButton buttonFloatingAction;
    private View layoutLauncherBadge;
    private TextView textBadgeCount;
    private int defaultMargin;
    private Animation launcherAnimation;
    private Animation badgeAnimation;
    @Nullable
    private Binder launcherConfigBinder;
    @Nullable
    private Binder styleBinder;

    public ChannelLauncherView(@NonNull Context context) {
        super(context);
        this.initView(context);
    }

    public ChannelLauncherView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public ChannelLauncherView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    private void initView(Context context) {
        this.context = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.ch_plugin_view_launcher, (ViewGroup)this, true);
        this.buttonFloatingAction = (FloatingActionButton)view.findViewById(R.id.ch_fabLauncher);
        this.buttonFloatingAction.setColorRipple(-1);
        this.buttonFloatingAction.setOnClickListener(v -> {
            if (context instanceof Activity) {
                ChannelIO.showMessenger((Activity)context);
            }
        });
        this.layoutLauncherBadge = view.findViewById(R.id.ch_layoutLauncherBadge);
        this.textBadgeCount = (TextView)view.findViewById(R.id.ch_textLauncherBadge);
        this.defaultMargin = context.getResources().getDimensionPixelSize(R.dimen.ch_default_channel_button_margin);
        this.launcherAnimation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.ch_plugin_anim_launcher);
        this.badgeAnimation = AnimationUtils.loadAnimation((Context)context, (int)R.anim.ch_plugin_anim_launcher_badge);
        this.setVisibility(8);
        this.textBadgeCount.setVisibility(8);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.launcherConfigBinder = SettingsSelector.bindLauncherConfig((Action1<ChannelButtonOption>)((Action1)this::setLauncherLayout));
        this.styleBinder = GlobalSelector.bindLauncherStyle((Action3<Plugin, Integer, Boolean>)((Action3)(plugin, alert, hasMarketingChat) -> {
            this.setLauncherBackgroundColor(plugin.getBackgroundColor(), plugin.getGradientColor());
            this.setBadgeCount((Integer)alert);
            this.setLauncherIcon(UIUtils.getLauncherIcon(alert, plugin.getTextColor(), hasMarketingChat));
        }));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.hide();
        if (this.launcherConfigBinder != null) {
            this.launcherConfigBinder.unbind();
        }
        if (this.styleBinder != null) {
            this.styleBinder.unbind();
        }
    }

    public void show() {
        if (this.getVisibility() == 8) {
            this.setVisibility(0);
            this.buttonFloatingAction.startAnimation(this.launcherAnimation);
            this.layoutLauncherBadge.startAnimation(this.badgeAnimation);
        }
    }

    public void hide() {
        this.buttonFloatingAction.clearAnimation();
        this.layoutLauncherBadge.clearAnimation();
        this.setVisibility(8);
    }

    private void setLauncherLayout(@Nullable ChannelButtonOption channelButtonOption) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(12);
        params.addRule(10, 0);
        switch (this.getGravity(channelButtonOption)) {
            case 0: {
                if (Build.VERSION.SDK_INT >= 17) {
                    params.addRule(20);
                    params.addRule(21, 0);
                }
                params.addRule(9);
                params.addRule(11, 0);
                params.setMargins(this.getXMargin(channelButtonOption), 0, 0, this.getYMargin(channelButtonOption));
                break;
            }
            case 1: {
                if (Build.VERSION.SDK_INT >= 17) {
                    params.addRule(20, 0);
                    params.addRule(21);
                }
                params.addRule(9, 0);
                params.addRule(11);
                params.setMargins(0, 0, this.getXMargin(channelButtonOption), this.getYMargin(channelButtonOption));
            }
        }
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.requestLayout();
        this.textBadgeCount.bringToFront();
    }

    private int getXMargin(@Nullable ChannelButtonOption option) {
        if (option != null) {
            return (int)Utils.dpToPx(this.context, option.getXMargin());
        }
        return this.defaultMargin;
    }

    private int getYMargin(@Nullable ChannelButtonOption option) {
        if (option != null) {
            return (int)Utils.dpToPx(this.context, option.getYMargin());
        }
        return this.defaultMargin;
    }

    private int getGravity(@Nullable ChannelButtonOption option) {
        if (option != null) {
            return option.getLauncherGravity();
        }
        return 1;
    }

    private void setLauncherBackgroundColor(int backgroundColor, int gradientColor) {
        this.buttonFloatingAction.setColorNormalWithGradient(backgroundColor, gradientColor);
        this.buttonFloatingAction.setColorPressed(Utils.addBlackMask(backgroundColor));
    }

    private void setBadgeCount(Integer chatCount) {
        if (chatCount == null || chatCount <= 0) {
            this.textBadgeCount.setVisibility(8);
        } else {
            this.textBadgeCount.setVisibility(0);
            this.textBadgeCount.setText((CharSequence)Utils.getCount(chatCount, true));
        }
    }

    private void setLauncherIcon(int launcherIcon) {
        this.buttonFloatingAction.setImageResource(launcherIcon);
    }
}

