package com.zoyi.channel.plugin.android.open.enumerate;

import com.zoyi.channel.plugin.android.global.Const;

public enum BootStatus {
  SUCCESS(Const.BOOT_STATUS_SUCCESS),
  NOT_INITIALIZED(Const.BOOT_STATUS_NOT_INITIALIZED),
  NETWORK_TIMEOUT(Const.BOOT_STATUS_NETWORK_TIMEOUT),
  NOT_AVAILABLE_VERSION(Const.BOOT_STATUS_NOT_AVAILABLE_VERSION),
  SERVICE_UNDER_CONSTRUCTION(Const.BOOT_STATUS_SERVICE_UNDER_CONSTRUCTION),
  REQUIRE_PAYMENT(Const.BOOT_STATUS_REQUIRE_PAYMENT),
  ACCESS_DENIED(Const.BOOT_STATUS_ACCESS_DENIED),
  UNKNOWN_ERROR(Const.BOOT_STATUS_UNKNOWN_ERROR);

  private final String value;

  BootStatus(String value) {
    this.value = value;
  }

  public String toValue() {
    return value;
  }
}
