/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.push;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.store.UserStore;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.com.annimon.stream.Optional;

public class ChannelPushClient {
    public static boolean hasStoredPushNotification(Activity activity) {
        return PrefSupervisor.hasLatestBootData((Context)activity);
    }

    public static void openStoredPushNotification(Activity activity) {
        ChannelPushManager.clearNotification((Context)activity);
        if (PrefSupervisor.hasLatestPushData((Context)activity) && PrefSupervisor.hasLatestBootData((Context)activity)) {
            if (ChannelIO.isBooted()) {
                if (!ChannelPushClient.launchChat(activity)) {
                    L.e("Push Notification : Channel or user does not match for latest push notification");
                }
            } else if (ChannelIO.isInitialized()) {
                String pluginKey = PrefSupervisor.getLatestPluginKey((Context)activity);
                String pushChatId = ChannelPushClient.getValidPushNotificationChatId(activity, PrefSupervisor.getLatestBootedChannelId((Context)activity), PrefSupervisor.getLatestBootedUserId((Context)activity));
                if (pluginKey != null && pushChatId != null) {
                    ChannelPluginSettings pluginSettings = new ChannelPluginSettings(pluginKey);
                    ChannelIO.boot(pluginSettings, (status, user) -> {
                        switch (status) {
                            case SUCCESS: {
                                ChannelPushClient.launchChat(activity);
                                break;
                            }
                            case NOT_INITIALIZED: {
                                L.e("Push Notification : This plugin is Not initialized");
                                break;
                            }
                            case NETWORK_TIMEOUT: {
                                L.e("Push Notification : Network timeout error!");
                                break;
                            }
                            case ACCESS_DENIED: {
                                L.e("Push Notification : Access denied!");
                                break;
                            }
                            case REQUIRE_PAYMENT: {
                                L.e("Push Notification : Require payment!");
                                break;
                            }
                            case NOT_AVAILABLE_VERSION: {
                                L.e("Push Notification : Check Plugin version");
                                break;
                            }
                            case SERVICE_UNDER_CONSTRUCTION: {
                                L.e("Push Notification : Service is now under construction");
                                break;
                            }
                            default: {
                                L.e("Push Notification : Unknown error");
                            }
                        }
                    });
                } else {
                    L.e("Push Notification : Latest booted plugin key is not exists or Channel or user does not match for latest push notification");
                }
            } else {
                L.e("Push Notification : Please initialize ChannelIO first");
            }
        }
    }

    @Nullable
    public static String getValidPushNotificationChatId(Activity activity, @Nullable String channelId, @Nullable String userId) {
        String pushChannelId = PrefSupervisor.getLatestPushChannelId((Context)activity);
        String pushUserId = PrefSupervisor.getLatestPushUserId((Context)activity);
        String pushChatId = PrefSupervisor.getLatestPushChatId((Context)activity);
        if (channelId != null && userId != null && channelId.equals(pushChannelId) && userId.equals(pushUserId)) {
            return pushChatId;
        }
        return null;
    }

    public static boolean launchChat(Activity activity) {
        String currentChannelId = (String)Optional.ofNullable((Object)ChannelStore.get().channelState.get()).map(Channel::getId).orElse(null);
        String currentUserId = (String)Optional.ofNullable((Object)UserStore.get().user.get()).map(User::getId).orElse(null);
        String pushChatId = ChannelPushClient.getValidPushNotificationChatId(activity, currentChannelId, currentUserId);
        PrefSupervisor.clearLatestPushData((Context)activity);
        if (pushChatId != null) {
            ChannelIO.openChat(activity, pushChatId, null);
            return true;
        }
        return false;
    }
}

