package com.zoyi.channel.plugin.android.activity.profile.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.view.dialog.DatetimeDialog;
import com.zoyi.com.annimon.stream.Optional;

public class EditProfileDateView extends FrameLayout implements BaseEditProfileView {

  private View buttonEdit;
  private TextView textView;
  private View buttonClear;

  @Nullable
  private Long timestamp;

  public EditProfileDateView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public EditProfileDateView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public EditProfileDateView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  @Initializer
  @Override
  public void init(Context context) {
    View root = LayoutInflater.from(context).inflate(R.layout.ch_view_edit_profile_date, this, true);

    buttonEdit = root.findViewById(R.id.ch_buttonEditProfileDate);
    textView = root.findViewById(R.id.ch_textEditProfileDate);
    buttonClear = root.findViewById(R.id.ch_buttonEditProfileDateClear);

    buttonEdit.setOnClickListener(v -> new DatetimeDialog(getContext()).show(timestamp, this::setValue));
    buttonClear.setOnClickListener(v -> setValue(null));
  }

  @Override
  public void focus() {
  }

  @Override
  public boolean isValidValue() {
    return true;
  }

  @Nullable
  @Override
  public Object getValue() {
    return timestamp;
  }

  @Override
  public void setValue(@Nullable Object value) {
    this.timestamp = ParseUtils.parseLong(value);

    textView.setText(Optional.ofNullable(this.timestamp).map(TimeUtils::formatDatetime).orElse(null));
    Views.setVisibility(buttonClear, this.timestamp != null);
  }
}
