/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.SkipAttachChannelView;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.draw.Display;

public class ActivityInterceptor
implements Application.ActivityLifecycleCallbacks {
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
        L.d("ActivityLifecycle:Started: " + activity.getClass().getSimpleName());
        if (!Display.isLocked()) {
            FrameLayout root;
            GlobalStore.get().topActivity.set(activity);
            if (!ChannelUtils.isChannelPluginActivity((Context)activity) && ChannelIO.isAttachChannelView() && (root = (FrameLayout)activity.findViewById(R.id.channel_io_view)) == null && !activity.getClass().isAnnotationPresent(SkipAttachChannelView.class)) {
                root = new FrameLayout((Context)activity);
                root.setClipChildren(false);
                root.setClipToPadding(false);
                root.setFitsSystemWindows(true);
                root.setId(R.id.channel_io_view);
                try {
                    root.addView((View)new ChannelView((Context)activity));
                    activity.addContentView((View)root, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                }
                catch (Exception e) {
                    L.e(e.getMessage());
                }
            }
        }
    }

    public void onActivityResumed(Activity activity) {
        L.d("ActivityLifecycle:Resumed: " + activity.getClass().getSimpleName());
        if (!Display.isLocked()) {
            GlobalStore.get().topActivity.set(activity);
        }
    }

    public void onActivityPaused(Activity activity) {
        L.d("ActivityLifecycle:Paused: " + activity.getClass().getSimpleName());
        if (GlobalStore.get().topActivity.get() == activity) {
            GlobalStore.get().topActivity.set(null);
        }
    }

    public void onActivityStopped(Activity activity) {
        L.d("ActivityLifecycle:Stopped: " + activity.getClass().getSimpleName());
        if (GlobalStore.get().topActivity.get() == activity) {
            GlobalStore.get().topActivity.set(null);
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

