/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.open.callback.BootCallback;
import com.zoyi.channel.plugin.android.open.config.BootConfig;
import com.zoyi.channel.plugin.android.open.enumerate.BootStatus;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.rx.Observable;

public class BootManager {
    public static Observable<PluginWrapper> bootPlugin(BootConfig bootConfig) {
        String veilId = PrefSupervisor.getVeilId(ChannelIO.getAppContext());
        if (veilId != null && veilId.length() > 16) {
            veilId = veilId.substring(0, 16);
        }
        return Api.getSimpleApi().boot(bootConfig.getLanguage().toString(), bootConfig.getPluginKey(), bootConfig.getMemberId(), bootConfig.getMemberHash(), bootConfig.getUnsubscribed(), null, bootConfig.getProfile(), veilId);
    }

    public static boolean isValidVersion(PackageWrapper packageWrapper, BootCallback bootCallback) {
        if (packageWrapper == null) {
            if (bootCallback != null) {
                bootCallback.onComplete(BootStatus.NETWORK_TIMEOUT, null);
            }
            return false;
        }
        if (packageWrapper.isNeedToUpgrade()) {
            if (bootCallback != null) {
                bootCallback.onComplete(BootStatus.NOT_AVAILABLE_VERSION, null);
            }
            return false;
        }
        if (!CompareUtils.isSame(packageWrapper.getVersionString(), "8.0.0-beta10")) {
            L.i("Newest version is: " + packageWrapper.getVersionString());
        }
        return true;
    }

    public static boolean isValidPlugin(PluginWrapper pluginWrapper, BootCallback bootCallback) {
        if (pluginWrapper == null || !pluginWrapper.isValid()) {
            if (bootCallback != null) {
                bootCallback.onComplete(BootStatus.NETWORK_TIMEOUT, null);
            }
            return false;
        }
        if (!pluginWrapper.canUseMobileSDK()) {
            if (bootCallback != null) {
                bootCallback.onComplete(BootStatus.REQUIRE_PAYMENT, null);
            }
            return false;
        }
        return true;
    }

    public static void sendNetworkError(BootCallback bootCallback, RetrofitException exception) {
        if (bootCallback != null) {
            String errorMessage = "Unknown error";
            if (exception != null) {
                errorMessage = exception.getMessage();
                BootStatus status = exception.is4xxClientError() ? BootStatus.ACCESS_DENIED : (exception.is5xxServerError() ? BootStatus.SERVICE_UNDER_CONSTRUCTION : (exception.isConnectionTimeOutError() ? BootStatus.NETWORK_TIMEOUT : (exception.isHttpError() ? BootStatus.NOT_INITIALIZED : BootStatus.UNKNOWN_ERROR)));
                bootCallback.onComplete(status, null);
            } else {
                bootCallback.onComplete(BootStatus.UNKNOWN_ERROR, null);
            }
            L.e(errorMessage);
        }
    }
}

