/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextUtils;
import android.util.Log;
import com.zoyi.channel.plugin.android.ChannelPluginCompletionStatus;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.OnBootListener;
import com.zoyi.channel.plugin.android.Profile;
import com.zoyi.channel.plugin.android.RealChannelIO;
import com.zoyi.channel.plugin.android.action.EventAction;
import com.zoyi.channel.plugin.android.action.TagAction;
import com.zoyi.channel.plugin.android.action.UserAction;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Event;
import com.zoyi.channel.plugin.android.open.callback.BootCallback;
import com.zoyi.channel.plugin.android.open.callback.UserUpdateCallback;
import com.zoyi.channel.plugin.android.open.config.BootConfig;
import com.zoyi.channel.plugin.android.open.enumerate.BootStatus;
import com.zoyi.channel.plugin.android.open.exception.ChannelException;
import com.zoyi.channel.plugin.android.open.model.User;
import com.zoyi.channel.plugin.android.open.model.UserData;
import com.zoyi.channel.plugin.android.push.ChannelPushClient;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.selector.GlobalSelector;
import com.zoyi.channel.plugin.android.store.PluginStore;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.util.ListUtils;
import java.util.List;
import java.util.Map;

public class ChannelIO {
    private static boolean isDebugMode = true;
    private static boolean attachChannelView = true;
    @Nullable
    private static RealChannelIO realChannelIO;

    public static void initialize(@Nullable Application application) {
        ChannelIO.initialize(application, true);
    }

    public static void initialize(@Nullable Application application, boolean attachView) {
        if (application == null) {
            Log.e((String)"ChannelIO", (String)"Fail to 'initialize', Application can't be NULL");
        } else if (realChannelIO != null) {
            Log.e((String)"ChannelIO", (String)"Fail to 'initialize', Channel plugin already initialized");
        } else {
            attachChannelView = attachView;
            realChannelIO = new RealChannelIO(application);
        }
    }

    public static boolean isAttachChannelView() {
        return attachChannelView;
    }

    public static void setDebugMode(boolean enable) {
        isDebugMode = enable;
    }

    @Deprecated
    public static void boot(@Nullable ChannelPluginSettings pluginSettings) {
        ChannelIO.boot(pluginSettings, null, null);
    }

    @Deprecated
    public static void boot(@Nullable ChannelPluginSettings pluginSettings, @Nullable OnBootListener completion) {
        ChannelIO.boot(pluginSettings, null, completion);
    }

    @Deprecated
    public static void boot(@Nullable ChannelPluginSettings pluginSettings, @Nullable Profile profile) {
        ChannelIO.boot(pluginSettings, profile, null);
    }

    @Deprecated
    public static void boot(@Nullable ChannelPluginSettings pluginSettings, @Nullable Profile profile, @Nullable OnBootListener completion) {
        Log.w((String)"ChannelIO", (String)"This boot function is deprecated. Please use ChannelIO.boot(BootConfig) or ChannelIO.boot(BootConfig, BootCallback)");
        if (pluginSettings != null) {
            ChannelIO.setDebugMode(pluginSettings.isDebugMode());
        }
        ChannelIO.boot(BootConfig.fromLegacy(pluginSettings, profile), (BootStatus bootStatus, User user) -> {
            com.zoyi.channel.plugin.android.User legacyUser;
            com.zoyi.channel.plugin.android.User user2 = legacyUser = user != null ? user.toLegacy() : null;
            if (completion != null) {
                switch (bootStatus) {
                    case SUCCESS: {
                        completion.onCompletion(ChannelPluginCompletionStatus.SUCCESS, legacyUser);
                        break;
                    }
                    case NOT_INITIALIZED: {
                        completion.onCompletion(ChannelPluginCompletionStatus.NOT_INITIALIZED, legacyUser);
                        break;
                    }
                    case NETWORK_TIMEOUT: {
                        completion.onCompletion(ChannelPluginCompletionStatus.NETWORK_TIMEOUT, legacyUser);
                        break;
                    }
                    case NOT_AVAILABLE_VERSION: {
                        completion.onCompletion(ChannelPluginCompletionStatus.NOT_AVAILABLE_VERSION, legacyUser);
                        break;
                    }
                    case SERVICE_UNDER_CONSTRUCTION: {
                        completion.onCompletion(ChannelPluginCompletionStatus.SERVICE_UNDER_CONSTRUCTION, legacyUser);
                        break;
                    }
                    case REQUIRE_PAYMENT: {
                        completion.onCompletion(ChannelPluginCompletionStatus.REQUIRE_PAYMENT, legacyUser);
                        break;
                    }
                    case ACCESS_DENIED: {
                        completion.onCompletion(ChannelPluginCompletionStatus.ACCESS_DENIED, legacyUser);
                        break;
                    }
                    default: {
                        completion.onCompletion(ChannelPluginCompletionStatus.UNKNOWN_ERROR, legacyUser);
                    }
                }
            }
        });
    }

    public static void boot(@Nullable BootConfig bootConfig) {
        ChannelIO.boot(bootConfig, null);
    }

    public static void boot(@Nullable BootConfig bootConfig, @Nullable BootCallback bootCallback) {
        if (realChannelIO == null) {
            Log.e((String)"ChannelIO", (String)"Fail to boot, Initialize first");
            if (bootCallback != null) {
                bootCallback.onComplete(BootStatus.NOT_INITIALIZED, null);
            }
        } else if (bootConfig == null || bootConfig.getPluginKey() == null) {
            Log.e((String)"ChannelIO", (String)"Fail to boot, Check boot configuration");
            if (bootCallback != null) {
                bootCallback.onComplete(BootStatus.NOT_INITIALIZED, null);
            }
        } else {
            realChannelIO.boot(bootConfig, bootCallback);
        }
    }

    public static void sleep() {
        if (realChannelIO != null) {
            realChannelIO.sleep();
        }
    }

    public static void shutdown() {
        if (realChannelIO != null) {
            realChannelIO.shutdown();
        }
    }

    public static void showMessenger(@Nullable Activity activity) {
        if (activity != null && realChannelIO != null) {
            realChannelIO.showMessenger(activity);
        }
    }

    @Deprecated
    public static boolean open(@Nullable Context context) {
        Log.w((String)"ChannelIO", (String)"ChannelIO.open(Context) is deprecated. Please use ChannelIO.showMessenger(Activity)");
        return ChannelIO.open(context, true);
    }

    @Deprecated
    public static boolean open(@Nullable Context context, boolean animate) {
        Log.w((String)"ChannelIO", (String)"ChannelIO.open(Context, boolean) is deprecated. Please use ChannelIO.showMessenger(Activity)");
        if (context instanceof Activity && realChannelIO != null) {
            ChannelIO.showMessenger((Activity)context);
            return true;
        }
        return false;
    }

    public static void hideMessenger() {
        Action.invoke(ActionType.EXIT);
    }

    @Deprecated
    public static void close() {
        Log.w((String)"ChannelIO", (String)"ChannelIO.close() is deprecated. Please use ChannelIO.hideMessenger()");
        ChannelIO.hideMessenger();
    }

    @Deprecated
    public static void close(boolean animated) {
        Log.w((String)"ChannelIO", (String)"ChannelIO.close(boolean) is deprecated. Please use ChannelIO.hideMessenger()");
        ChannelIO.hideMessenger();
    }

    public static void openChat(@Nullable Activity activity, @Nullable String chatId, @Nullable String message) {
        if (activity != null && realChannelIO != null) {
            realChannelIO.openChat(activity, chatId, message);
        }
    }

    @Deprecated
    public static boolean openChat(@Nullable Context context) {
        Log.w((String)"ChannelIO", (String)"ChannelIO.openChat(Context) is deprecated. Please use ChannelIO.openChat(Activity, String, String)");
        return ChannelIO.openChat(context, null);
    }

    @Deprecated
    public static boolean openChat(@Nullable Context context, @Nullable String chatId) {
        Log.w((String)"ChannelIO", (String)"ChannelIO.openChat(Context, String) is deprecated. Please use ChannelIO.openChat(Activity, String, String)");
        return ChannelIO.openChat(context, chatId, true);
    }

    @Deprecated
    public static boolean openChat(@Nullable Context context, @Nullable String chatId, boolean animate) {
        Log.w((String)"ChannelIO", (String)"ChannelIO.openChat(Context, String, boolean) is deprecated. Please use ChannelIO.openChat(Activity, String, String)");
        if (context instanceof Activity && realChannelIO != null) {
            ChannelIO.openChat((Activity)context, chatId, null);
            return true;
        }
        return false;
    }

    public static void showChannelButton() {
        if (!SettingsStore.get().showLauncher.get().booleanValue()) {
            SettingsStore.get().showLauncher.set(true);
            if (ChannelIO.isBooted() && SettingsStore.get().trackDefaultEvent.get().booleanValue()) {
                EventAction.trackPageView();
            }
        }
    }

    @Deprecated
    public static void show() {
        Log.w((String)"ChannelIO", (String)"ChannelIO.show() is deprecated. Please use ChannelIO.showChannelButton()");
        ChannelIO.showChannelButton();
    }

    public static void hideChannelButton() {
        SettingsStore.get().showLauncher.set(false);
    }

    @Deprecated
    public static void hide() {
        Log.w((String)"ChannelIO", (String)"ChannelIO.hide() is deprecated. Please use ChannelIO.hideChannelButton()");
        ChannelIO.hideChannelButton();
    }

    @Deprecated
    public static boolean canShowLauncher() {
        Log.w((String)"ChannelIO", (String)"ChannelIO.canShowLauncher() is deprecated.");
        return GlobalSelector.getLauncherVisibility();
    }

    public static void setListener(com.zoyi.channel.plugin.android.open.listener.ChannelPluginListener listener) {
        if (realChannelIO != null) {
            realChannelIO.setListener(listener);
        }
    }

    @Deprecated
    public static void setChannelPluginListener(ChannelPluginListener channelPluginListener) {
        Log.w((String)"ChannelIO", (String)"ChannelIO.setChannelPluginListener is deprecated. Please use ChannelIO.setListener");
        if (realChannelIO != null) {
            realChannelIO.setListener(channelPluginListener);
        }
    }

    public static void clearListener() {
        if (realChannelIO != null) {
            realChannelIO.clearListener();
        }
    }

    @Deprecated
    public static void clearChannelPluginListener() {
        ChannelIO.clearListener();
    }

    @Nullable
    public static ChannelPluginListener getLegacyListener() {
        if (realChannelIO != null) {
            return realChannelIO.getLegacyListener();
        }
        return null;
    }

    @Nullable
    public static com.zoyi.channel.plugin.android.open.listener.ChannelPluginListener getListener() {
        if (realChannelIO != null) {
            return realChannelIO.getListener();
        }
        return null;
    }

    public static void track(@NonNull @Size(min=1L, max=30L) String eventName) {
        ChannelIO.track(eventName, null);
    }

    public static void track(@NonNull @Size(min=1L, max=30L) String eventName, @Nullable Map<String, Object> eventProperty) {
        if (TextUtils.isEmpty((CharSequence)eventName)) {
            Log.e((String)"ChannelIO", (String)"Fail to track event. Event name can't be blank or null.");
            return;
        }
        if (eventName.length() > 30) {
            Log.e((String)"ChannelIO", (String)"Fail to track event. Event name must be 30 characters or less.");
            return;
        }
        String jwt = PrefSupervisor.getJwt(ChannelIO.getAppContext());
        if (jwt == null) {
            Log.e((String)"ChannelIO", (String)"Fail to track event. Unauthorized access.");
            return;
        }
        EventAction.track(new Event(eventName, eventProperty));
    }

    public static void initPushToken(String token) {
        Context context = ChannelIO.getAppContext();
        if (context != null) {
            PrefSupervisor.setDeviceToken(context, token);
        }
        if (realChannelIO != null) {
            realChannelIO.registerPushToken();
        }
    }

    public static boolean isChannelPushNotification(Map<String, String> message) {
        return ChannelPushManager.isChannelPushNotification(message);
    }

    public static boolean hasStoredPushNotification(@Nullable Activity activity) {
        if (activity != null) {
            return ChannelPushClient.hasStoredPushNotification(activity);
        }
        return false;
    }

    public static void openStoredPushNotification(@Nullable Activity activity) {
        if (activity != null) {
            ChannelPushClient.openStoredPushNotification(activity);
        }
    }

    @Deprecated
    public static void handlePushNotification(@Nullable Activity activity) {
        Log.w((String)"ChannelIO", (String)"ChannelIO.handlePushNotification(Activity) is deprecated. Please use ChannelIO.openStoredPushNotification(Activity)");
        ChannelIO.openStoredPushNotification(activity);
    }

    public static void receivePushNotification(Context context, Map<String, String> message) {
        if (context != null) {
            ChannelPushManager.receivePushNotification(context, message);
        }
    }

    @Deprecated
    public static void showPushNotification(Context context, Map<String, String> message) {
        Log.w((String)"ChannelIO", (String)"ChannelIO.showPushNotification(Context, Map) is deprecated. Please use ChannelIO.receivePushNotification(Context, Map)");
        ChannelIO.receivePushNotification(context, message);
    }

    public static void updateUser(@Nullable UserData userData, @Nullable UserUpdateCallback callback) {
        if (ChannelIO.isBooted()) {
            UserAction.updateUser(userData, callback);
        } else if (callback != null) {
            callback.onComplete(ChannelException.newInstance("Please boot first"), null);
        }
    }

    @Deprecated
    public static void updateProfile(Map<String, Object> profileMap) {
        ChannelIO.updateUser(new UserData.Builder().setProfileMap(profileMap).build(), null);
    }

    public static void addTags(String ... tags) {
        if (tags != null) {
            ChannelIO.addTags(ListUtils.newArrayList(tags), null);
        }
    }

    public static void addTags(List<String> tags, @Nullable UserUpdateCallback callback) {
        if (ChannelIO.isBooted()) {
            TagAction.addTags(tags, callback);
        } else if (callback != null) {
            callback.onComplete(ChannelException.newInstance("Please boot first"), null);
        }
    }

    public static void removeTags(String ... tags) {
        if (tags != null) {
            ChannelIO.removeTags(ListUtils.newArrayList(tags), null);
        }
    }

    public static void removeTags(List<String> tags, @Nullable UserUpdateCallback callback) {
        if (ChannelIO.isBooted()) {
            TagAction.removeTags(tags, callback);
        } else if (callback != null) {
            callback.onComplete(ChannelException.newInstance("Please boot first"), null);
        }
    }

    public static boolean isInitialized() {
        return realChannelIO != null;
    }

    @Nullable
    public static Context getAppContext() {
        if (realChannelIO != null) {
            return realChannelIO.getApplication();
        }
        return null;
    }

    public static boolean isDebugMode() {
        return isDebugMode;
    }

    public static boolean isBooted() {
        return PluginStore.get().pluginState.get() != null;
    }
}

