/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.youtube.player.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.youtube.player.YouTubePlayer;
import com.zoyi.channel.plugin.android.view.youtube.player.YouTubePlayerBridge;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.YouTubePlayerListener;
import com.zoyi.channel.plugin.android.view.youtube.player.option.IFramePlayerOptions;
import com.zoyi.channel.plugin.android.view.youtube.player.util.Utils;
import com.zoyi.rx.functions.Action1;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class WebViewYouTubePlayer
extends WebView
implements YouTubePlayer,
YouTubePlayerBridge.YouTubePlayerBridgeCallbacks {
    @Nullable
    private Action1<YouTubePlayer> youTubePlayerInitListener;
    private Set<YouTubePlayerListener> youTubePlayerListeners;
    private Handler mainThreadHandler;
    private boolean isBackgroundPlaybackEnabled = false;

    public WebViewYouTubePlayer(Context context) {
        super(context);
        this.init();
    }

    public WebViewYouTubePlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public WebViewYouTubePlayer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public boolean isBackgroundPlaybackEnabled() {
        return this.isBackgroundPlaybackEnabled;
    }

    public void setBackgroundPlaybackEnabled(boolean backgroundPlaybackEnabled) {
        this.isBackgroundPlaybackEnabled = backgroundPlaybackEnabled;
    }

    @Initializer
    private void init() {
        this.youTubePlayerListeners = new HashSet<YouTubePlayerListener>();
        this.mainThreadHandler = new Handler(Looper.getMainLooper());
    }

    public void initialize(Action1<YouTubePlayer> initListener, @Nullable IFramePlayerOptions playerOptions) throws IOException {
        this.youTubePlayerInitListener = initListener;
        this.initWebView(playerOptions == null ? IFramePlayerOptions.DEFAULT : playerOptions);
    }

    @Override
    public void onYouTubeIFrameAPIReady() {
        if (this.youTubePlayerInitListener != null) {
            this.youTubePlayerInitListener.call((Object)this);
        }
    }

    @Override
    public YouTubePlayer getInstance() {
        return this;
    }

    @Override
    public void loadVideo(@Nullable String videoId, float startSeconds) {
        if (videoId != null) {
            this.mainThreadHandler.post(() -> this.loadUrl(String.format(Locale.ENGLISH, "javascript:loadVideo('%s', %f)", videoId, Float.valueOf(startSeconds))));
        }
    }

    @Override
    public void cueVideo(@Nullable String videoId, float startSeconds) {
        if (videoId != null) {
            this.mainThreadHandler.post(() -> this.loadUrl(String.format(Locale.ENGLISH, "javascript:loadVideo('%s', %f)", videoId, Float.valueOf(startSeconds))));
        }
    }

    @Override
    public void play() {
        this.mainThreadHandler.post(() -> this.loadUrl("javascript:playVideo()"));
    }

    @Override
    public void pause() {
        this.mainThreadHandler.post(() -> this.loadUrl("javascript:pauseVideo()"));
    }

    @Override
    public void mute() {
        this.mainThreadHandler.post(() -> this.loadUrl("javascript:mute()"));
    }

    @Override
    public void unMute() {
        this.mainThreadHandler.post(() -> this.loadUrl("javascript:unMute()"));
    }

    @Override
    public void setVolume(int volumePercent) {
        if (volumePercent < 0 || volumePercent > 100) {
            throw new IllegalArgumentException("Volume must be between 0 and 100");
        }
        this.mainThreadHandler.post(() -> this.loadUrl(String.format(Locale.ENGLISH, "javascript:setVolume(%d)", volumePercent)));
    }

    @Override
    public void seekTo(float time) {
        this.mainThreadHandler.post(() -> this.loadUrl(String.format(Locale.ENGLISH, "javascript:seekTo(%f)", Float.valueOf(time))));
    }

    public void destroy() {
        this.youTubePlayerListeners.clear();
        this.mainThreadHandler.removeCallbacksAndMessages(null);
        super.destroy();
    }

    @Override
    public Collection<YouTubePlayerListener> getListeners() {
        return new HashSet<YouTubePlayerListener>(this.youTubePlayerListeners);
    }

    @Override
    public boolean addListener(YouTubePlayerListener listener) {
        return this.youTubePlayerListeners.add(listener);
    }

    @Override
    public boolean removeListener(YouTubePlayerListener listener) {
        return this.youTubePlayerListeners.remove(listener);
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void initWebView(IFramePlayerOptions playerOptions) throws IOException {
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setCacheMode(2);
        if (Build.VERSION.SDK_INT >= 17) {
            this.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        this.addJavascriptInterface(new YouTubePlayerBridge(this), "YouTubePlayerBridge");
        String htmlPage = Utils.readHTMLFromUTF8File(this.getResources().openRawResource(R.raw.ch_plugin_ayp_youtube_player)).replace("<<injectedPlayerVars>>", playerOptions.toString());
        this.loadDataWithBaseURL(playerOptions.getOrigin(), htmlPage, "text/html", "utf-8", null);
        this.setWebChromeClient(new WebChromeClient(){

            public Bitmap getDefaultVideoPoster() {
                Bitmap result = super.getDefaultVideoPoster();
                return result == null ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.RGB_565) : result;
            }
        });
    }

    public void onWindowVisibilityChanged(int visibility) {
        if (this.isBackgroundPlaybackEnabled && (visibility == 8 || visibility == 4)) {
            return;
        }
        super.onWindowVisibilityChanged(visibility);
    }
}

