package com.zoyi.channel.plugin.android.push;

import android.content.*;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.open.listener.ChannelPluginListener;

public class ChannelBroadcastReceiver extends BroadcastReceiver {

  static final String ACTION_CHANNEL_PLUGIN_PUSH_CLICK = "com.zoyi.channel.plugin.android.push.CHANNEL_PUSH_CLICK";

  @Override
  public void onReceive(Context context, Intent intent) {
    if (intent != null && intent.getAction() != null) {
      if (ACTION_CHANNEL_PLUGIN_PUSH_CLICK.equals(intent.getAction())) {
        handlePushClick(context, intent);
      }
    }
  }

  private void handlePushClick(Context context, Intent intent) {
    Intent hostIntent = intent.getParcelableExtra(Const.EXTRA_HOST_APP_INTENT);

    if (hostIntent == null) {
      return;
    }

    String channelId = hostIntent.getStringExtra(Const.EXTRA_CHANNEL_ID);
    String personType = hostIntent.getStringExtra(Const.EXTRA_PERSON_TYPE);
    String personId = hostIntent.getStringExtra(Const.EXTRA_PERSON_ID);
    String chatId = hostIntent.getStringExtra(Const.EXTRA_CHAT_ID);

    if (channelId != null && chatId != null && Const.USER.equals(personType) && personId != null) {
      PrefSupervisor.setLatestPushData(context, channelId, personId, chatId);

      ChannelPluginListener listener = ChannelIO.getListener();

      if (listener != null) {
        boolean handled = listener.onPushNotificationClicked(chatId);

        if (handled) {
          return;
        }
      }

      context.startActivity(hostIntent);
    }
  }
}
