package com.zoyi.channel.plugin.android.global;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;

/**
 * Created by mika on 2017. 1. 16..
 */
public class PrefSupervisor {

  // Veil id
  private static final String VEIL_ID = "X-Veil-Id";

  // Device id and fcm token keys
  private static final String DEVICE_ID = "Device-Id";
  private static final String DEVICE_TOKEN = "Device-Token";
  private static final String SENT_DEVICE_TOKEN = "Sent-Device-Token";

  // Settings
  private static final String SHOW_CLOSED_CHAT = "Show-Closed-Chat-V2";
  private static final String ENABLE_PUSH_ALARM = "Enable-Push-Alarm";
  private static final String ENABLE_TRANSLATE_MESSAGE = "Enable-Translate-Message";

  // Jwt
  private static final String JWT = "Jwt_Token";

  // Latest boot data keys
  private static final String LATEST_PLUGIN_KEY = "LATEST_PLUGIN_KEY";
  private static final String LATEST_BOOTED_CHANNEL_ID = "LATEST_BOOTED_CHANNEL_ID";
  private static final String LATEST_BOOTED_USER_ID = "LATEST_BOOTED_USER_ID";

  // Latest received push data keys
  private static final String LATEST_PUSH_CHANNEL_ID = "LATEST_PUSH_CHANNEL_ID";
  private static final String LATEST_PUSH_USER_ID = "LATEST_PUSH_USER_ID";
  private static final String LATEST_PUSH_CHAT_ID = "LATEST_PUSH_CHAT_ID";

  // functions

  // Veil id

  @Nullable
  public static String getVeilId(@Nullable Context context) {
    return getString(context, VEIL_ID);
  }

  public static void setVeilId(@Nullable Context context, @Nullable String veilId) {
    setString(context, VEIL_ID, veilId);
  }

  // Device id and fcm token

  @Nullable
  public static String getDeviceId(Context context) {
    return getString(context, DEVICE_ID);
  }

  public static void setDeviceId(Context context, String deviceId) {
    setString(context, DEVICE_ID, deviceId);
  }

  @Nullable
  public static String getDeviceToken(Context context) {
    return getString(context, DEVICE_TOKEN);
  }

  public static void setDeviceToken(Context context, String token) {
    setString(context, DEVICE_TOKEN, token);
  }

  @Nullable
  public static String getSentDeviceToken(Context context) {
    return getString(context, SENT_DEVICE_TOKEN);
  }

  public static void setSentDeviceToken(Context context, @Nullable String token) {
    setString(context, SENT_DEVICE_TOKEN, token);
  }

  // Personal settings

  public static boolean isShownClosedChat(Context context) {
    return getBoolean(context, SHOW_CLOSED_CHAT, true);
  }

  public static void setShowClosedChat(Context context, boolean show) {
    setBoolean(context, SHOW_CLOSED_CHAT, show);
  }

  public static boolean isEnabledPushAlarm(Context context) {
    return getBoolean(context, ENABLE_PUSH_ALARM, true);
  }

  public static void setPushAlarm(Context context, boolean enabled) {
    setBoolean(context, ENABLE_PUSH_ALARM, enabled);
  }

  public static boolean canTranslateMessage(Context context) {
    return getBoolean(context, ENABLE_TRANSLATE_MESSAGE, true);
  }

  public static void setTranslateOption(Context context, boolean enable) {
    setBoolean(context, ENABLE_TRANSLATE_MESSAGE, enable);
  }

  // JWT

  @Nullable
  public static String getJwt(@Nullable Context context) {
    return getString(context, JWT);
  }

  public static void setJwt(@Nullable Context context, @Nullable String jwt) {
    setString(context, JWT, jwt);
  }

  // Latest boot data

  public static boolean hasLatestBootData(@Nullable Context context) {
    return getLatestPluginKey(context) != null && getLatestBootedChannelId(context) != null && getLatestBootedUserId(context) != null;
  }

  @Nullable
  public static String getLatestPluginKey(@Nullable Context context) {
    return getString(context, LATEST_PLUGIN_KEY);
  }

  @Nullable
  public static String getLatestBootedChannelId(@Nullable Context context) {
    return getString(context, LATEST_BOOTED_CHANNEL_ID);
  }

  @Nullable
  public static String getLatestBootedUserId(@Nullable Context context) {
    return getString(context, LATEST_BOOTED_USER_ID);
  }

  public static void setLatestBootData(
      @Nullable Context context,
      @Nullable String pluginKey,
      @Nullable String channelId,
      @Nullable String userId
  ) {
    openTransaction(context, editor -> {
      editor.putString(LATEST_PLUGIN_KEY, pluginKey);
      editor.putString(LATEST_BOOTED_CHANNEL_ID, channelId);
      editor.putString(LATEST_BOOTED_USER_ID, userId);
    });
  }

  public static void clearLatestBootData(@Nullable Context context) {
    setLatestBootData(context, null, null, null);
  }

  // Latest received push data

  public static boolean hasLatestPushData(@Nullable Context context) {
    return getLatestPushChannelId(context) != null && getLatestPushUserId(context) != null && getLatestPushChatId(context) != null;
  }

  @Nullable
  public static String getLatestPushChannelId(@Nullable Context context) {
    return getString(context, LATEST_PUSH_CHANNEL_ID);
  }

  @Nullable
  public static String getLatestPushUserId(@Nullable Context context) {
    return getString(context, LATEST_PUSH_USER_ID);
  }

  @Nullable
  public static String getLatestPushChatId(@Nullable Context context) {
    return getString(context, LATEST_PUSH_CHAT_ID);
  }

  public static void setLatestPushData(
      @Nullable Context context,
      @Nullable String channelId,
      @Nullable String userId,
      @Nullable String chatId
  ) {
    openTransaction(context, editor -> {
      editor.putString(LATEST_PUSH_CHANNEL_ID, channelId);
      editor.putString(LATEST_PUSH_USER_ID, userId);
      editor.putString(LATEST_PUSH_CHAT_ID, chatId);
    });
  }

  public static void clearLatestPushData(@Nullable Context context) {
    setLatestPushData(context, null, null, null);
  }

  // private processor

  private static SharedPreferences getPreferences(Context context) {
    return context.getSharedPreferences("CHANNEL_PLUGIN_PRIVATE_DATA", 0);
  }

  private static boolean getBoolean(@Nullable Context context, String key, boolean defaultValue) {
    if (context != null) {
      return getPreferences(context).getBoolean(key, defaultValue);
    }
    return defaultValue;
  }

  @Nullable
  private static String getString(@Nullable Context context, String key) {
    if (context != null) {
      return getPreferences(context).getString(key, null);
    }
    return null;
  }

  private static void setBoolean(@Nullable Context context, String key, boolean value) {
    openTransaction(context, editor -> editor.putBoolean(key, value));
  }

  private static void setString(@Nullable Context context, String key, @Nullable String value) {
    openTransaction(context, editor -> editor.putString(key, value));
  }

  private static void openTransaction(@Nullable Context context, OnTransactionCallback callback) {
    if (context != null) {
      SharedPreferences.Editor editor = getPreferences(context).edit();
      callback.onTransactionOpened(editor);
      editor.apply();
    }
  }

  // legacy

  private interface OnTransactionCallback {

    void onTransactionOpened(SharedPreferences.Editor editor);
  }
}
