/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.textview;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatTextView;
import android.text.Spanned;
import android.util.AttributeSet;
import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.selector.SettingsSelector;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.rx.functions.Action1;

public class CHTextView
extends AppCompatTextView {
    private Context context;
    @Nullable
    private String textKey;
    @Nullable
    private String hintTextKey;
    private boolean isHtml;
    @Nullable
    private Binder binder;

    public CHTextView(Context context) {
        super(context);
        this.init(context, null);
    }

    public CHTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CHTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer
    private void init(Context context, @Nullable AttributeSet attrs) {
        this.context = context;
        if (attrs != null) {
            TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.CHTextView);
            try {
                this.textKey = typedArray.getString(R.styleable.CHTextView_ch_tv_textKey);
                this.hintTextKey = typedArray.getString(R.styleable.CHTextView_ch_tv_hintKey);
                this.isHtml = typedArray.getBoolean(R.styleable.CHTextView_ch_tv_isHtml, false);
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.binder = SettingsSelector.bindLocale((Action1<CHLocale>)((Action1)locale -> {
                if (this.textKey != null) {
                    this.setTextKey((CHLocale)((Object)locale), this.textKey);
                }
                if (this.context != null && this.hintTextKey != null) {
                    this.setHint(ResUtils.getString(this.context, this.hintTextKey));
                }
            }));
        }
    }

    protected void onDetachedFromWindow() {
        if (this.binder != null) {
            this.binder.unbind();
            this.binder = null;
        }
        super.onDetachedFromWindow();
    }

    public void setText(@Nullable String text) {
        this.textKey = null;
        super.setText((CharSequence)text);
    }

    public void setText(@Nullable Spanned text) {
        this.textKey = null;
        super.setText((CharSequence)text);
    }

    public void setTextKey(@Nullable String textKey) {
        this.textKey = textKey;
        this.setTextKey((CHLocale)((Object)SettingsStore.get().locale.get()), textKey);
    }

    private void setTextKey(CHLocale locale, @Nullable String textKey) {
        if (textKey != null) {
            String content = ResUtils.getString(this.context, locale, textKey);
            this.setContent(content);
        }
    }

    private void setContent(@Nullable String content) {
        if (this.isHtml && content != null) {
            super.setText((CharSequence)Utils.getHtmlFormattedText(content));
        } else {
            super.setText((CharSequence)content);
        }
    }
}

