package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.util.AttributeSet;
import android.view.View;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.MarketingAction;
import com.zoyi.channel.plugin.android.model.entity.Previewable;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.view.media_thumbnail.FullScreenPopUpMediaThumbnailView;

import java.util.Locale;

public class FullScreenPushView extends BasePushView {

  public FullScreenPushView(@NonNull Context context) {
    super(context);
  }

  public FullScreenPushView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public FullScreenPushView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  @Override
  protected int getLayoutId() {
    return R.layout.ch_plugin_view_push_full_screen;
  }

  @Override
  protected void init(Context context) {
    super.init(context);

    ((FullScreenPopUpMediaThumbnailView) viewPopUpMedia).setOnFullScreenPopUpClickListener(() -> {
      if (item != null) {
        MarketingAction.sendClickEvent(item.getMarketing(), null);
      }
    });
  }

  @Override
  public void show(Message message) {
    super.show(message);
    MarketingAction.sendViewEvent(message.getMarketing());

    File file = message.getPrimaryFile();
    if (file != null && !file.isPreviewable()) {
      viewFileRow.setVisibility(View.VISIBLE);
      viewFileRow.setFile(file, message.getFiles().size());
    }
  }

  @Override
  protected void setMediaSize(Previewable previewable) {
    if (previewable.getHeight() != 0) {
      float maxRatio = 16f / 9f;
      float minRatio = 1f;
      float ratio = previewable.getWidth() / previewable.getHeight().floatValue();

      ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams) viewPopUpMedia.getLayoutParams();

      if (ratio < minRatio) {
        params.dimensionRatio = "1:1";
      } else if (ratio > maxRatio) {
        params.dimensionRatio = "16:9";
      } else {
        params.dimensionRatio = String.format(Locale.ENGLISH, "%d:%d", previewable.getWidth(), previewable.getHeight());
      }
    }
  }

  @Override
  public void resetView() {
    super.resetView();
  }

  @Override
  protected int getDefaultTextMaxLine() {
    return 8;
  }

  @Override
  protected int getAttachmentTextMaxLine() {
    return 4;
  }
}
