package com.zoyi.channel.plugin.android.open.model;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.okhttp3.RequestBody;

import java.util.List;
import java.util.Map;

public class UserData {

  @Nullable
  private RequestBody requestBody;

  private UserData(@Nullable RequestBody requestBody) {
    this.requestBody = requestBody;
  }

  @Nullable
  public RequestBody getRequestBody() {
    return requestBody;
  }

  public static class Builder {

    private RequestUtils requestUtils;

    public Builder() {
      this.requestUtils = RequestUtils.form();
    }

    public Builder setLocale(@Nullable CHLocale locale) {
      if (locale != null) {
        requestUtils.set(Const.USER_DATA_LANGUAGE, locale.toString());
      }
      return this;
    }

    public Builder setTags(@Nullable List<String> tags) {
      requestUtils.set(Const.USER_DATA_TAGS, tags);

      return this;
    }

    public Builder setProfileMap(@Nullable Map<String, Object> profileMap) {
      requestUtils.set(Const.USER_DATA_PROFILE, profileMap);

      return this;
    }

    public Builder setProfileOnceMap(@Nullable Map<String, Object> profileOnceMap) {
      requestUtils.set(Const.USER_DATA_PROFILE_ONCE, profileOnceMap);

      return this;
    }

    public Builder setUnsubscribed(boolean unsubscribed) {
      requestUtils.set(Const.USER_DATA_UNSUBSCRIBED, unsubscribed);

      return this;
    }

    public UserData build() {
      return new UserData(requestUtils.size() > 0 ? requestUtils.create() : null);
    }
  }
}
