package com.zoyi.channel.plugin.android.model.rest;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.BuildConfig;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.util.draw.Display;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.google.gson.Gson;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by ryan on 2017. 8. 28..
 */

public class Event {

  private String name;
  private Map<String, Object> property;

  public Event(@NonNull String name, @Nullable Map<String, Object> property) {
    this.name = name;

    this.property = Optional.ofNullable(property)
        .map(HashMap::new)
        .orElse(new HashMap<>());

    initProperty();
  }

  private void initProperty() {
    if (property == null) {
      property = new HashMap<>();
    }

    if (!property.containsKey(Const.SYS_PROPERTY_PLUGIN_VERSION) || property.get(Const.PROPERTY_URL) != null) {
      property.put(Const.SYS_PROPERTY_PLUGIN_VERSION, BuildConfig.CHANNEL_IO_VERSION);
    }

    if (!property.containsKey(Const.PROPERTY_URL) || property.get(Const.PROPERTY_URL) == null) {
      Activity topActivity = GlobalStore.get().topActivity.get();

      if (topActivity != null) {
        property.put(Const.SYS_PROPERTY_URL, topActivity.getClass().getSimpleName());
      }
    }

    Context context = ChannelIO.getAppContext();

    if (context != null) {
      property.put(Const.SYS_PROPERTY_SCREEN_WIDTH, Display.getWidth(context));
      property.put(Const.SYS_PROPERTY_SCREEN_HEIGHT, Display.getHeight(context));
    }
  }

  public String getName() {
    return name;
  }

  public String getPropertyToJson() {
    return new Gson().toJson(property);
  }
}
