package com.zoyi.channel.plugin.android.deserializer;

import com.zoyi.channel.plugin.android.model.rest.ProfileBot;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.com.google.gson.*;

import java.lang.reflect.Type;

public class ProfileBotDeserializer implements JsonDeserializer<ProfileBot> {

  @Override
  public ProfileBot deserialize(
      JsonElement jsonElement,
      Type t,
      JsonDeserializationContext jsonDeserializationContext
  ) throws JsonParseException {
    JsonObject root = jsonElement.getAsJsonObject();
    String id = root.get("id").getAsString();

    try {
      String key = root.get("key").getAsString();
      String type = root.get("type").getAsString();
      String name = root.get("name").getAsString();
      Object value = ParseUtils.parseJsonElement(root.get("value"));

      return new ProfileBot(id, key, type, name, value);
    } catch (Exception ex) {
    }
    return new ProfileBot(id, null, null, null, null);
  }
}
