package com.zoyi.channel.plugin.android.activity.chat.view.profilebot;

import android.app.Dialog;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.CountryAction;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store.CountryStore;
import com.zoyi.channel.plugin.android.store.ProfileBotStore;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.view.dialog.CountryCodeDialog;
import com.zoyi.channel.plugin.android.view.layout.ChBorderLayout;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;
import com.zoyi.rx.Subscription;

import java.util.List;
import java.util.Locale;

public class ProfileBotInputMobileNumberView extends BaseProfileBotInputView {

  public ProfileBotInputMobileNumberView(@NonNull Context context) {
    super(context);
  }

  public ProfileBotInputMobileNumberView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public ProfileBotInputMobileNumberView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  private ChBorderLayout borderLayout;
  private View buttonSelectCountry;
  private TextView textSelectedCountry;
  private WatchedEditText editText;
  private View progressView;
  private View buttonSubmit;
  private AppCompatImageView imageSubmit;

  @Nullable
  private Integer countryCode;

  private FetchState fetchState = FetchState.COMPLETE;

  @Nullable
  private Dialog dialog;

  @Nullable
  private Subscription subscription;

  @Initializer
  @Override
  public void initView(View root) {
    borderLayout = root.findViewById(R.id.ch_rootProfileBotInputMobileNumberView);
    buttonSelectCountry = root.findViewById(R.id.ch_buttonProfileBotInputMobileNumberSelectCountry);
    textSelectedCountry = root.findViewById(R.id.textProfileBotInputMobileNumberSelectCountry);
    editText = root.findViewById(R.id.ch_editProfileBotInputMobileNumber);
    progressView = root.findViewById(R.id.ch_progressProfileBotInputMobileNumber);
    buttonSubmit = root.findViewById(R.id.ch_buttonProfileBotInputMobileNumber);
    imageSubmit = root.findViewById(R.id.ch_imageProfileBotInputMobileNumberSubmit);

    editText.setOnFocusChangeListener((v, hasFocus) -> {
      resolveBorder(hasFocus);

      ProfileBotStore.get().requestFocus.set(true);
    });
    buttonSelectCountry.setOnClickListener(v -> requestCountrySelector());
    buttonSubmit.setOnClickListener(v -> submit());
  }

  @Nullable
  @Override
  public Object getValue() {
    if (countryCode != null && !editText.getString().isEmpty()) {
      return String.format(Locale.US, "+%d%s", countryCode, editText.getString());
    }
    return null;
  }

  @Override
  public void restore(@Nullable Object value, FetchState fetchState) {
    this.fetchState = fetchState;

    Views.setVisibility(progressView, fetchState == FetchState.LOADING);
    Views.setVisibility(buttonSubmit, fetchState != FetchState.LOADING);

    editText.setEnabled(fetchState != FetchState.LOADING);

    imageSubmit.setColorFilter(ResUtils.getColor(fetchState == FetchState.FAILED ? R.color.ch_orange400 : R.color.ch_cobalt400));

    resolveBorder(editText.hasFocus());

    // value

    MobileNumber mobileNumber = new MobileNumber(value != null ? value.toString() : null);

    countryCode = mobileNumber.getCountryCode();

    textSelectedCountry.setText(String.format(Locale.US, "+%d", mobileNumber.getCountryCode()));

    editText.setText(mobileNumber.getPhoneNumber());
    editText.setSelection(editText.getString().length());
  }

  private void resolveBorder(boolean hasFocus) {
    if (fetchState == FetchState.FAILED) {
      borderLayout.setBorderColor(ResUtils.getColor(R.color.ch_orange400));
    } else {
      borderLayout.setBorderColor(ResUtils.getColor(hasFocus ? R.color.ch_cobalt400 : R.color.ch_grey300));
    }
  }

  @Override
  public void focus() {
    editText.requestFocus();
  }

  @Override
  public int getLayoutId() {
    return R.layout.ch_view_profile_bot_input_mobile_number;
  }

  private void requestCountrySelector() {
    List<Country> countries = CountryStore.get().countries.get();

    if (countries == null) {
      showProgress(ResUtils.getString(getContext(), "ch.loading_information"));

      subscription = CountryAction.fetchCountries(new RestSubscriber<List<Country>>() {
        @Override
        public void onError(RetrofitException error) {
          hideProgress();
        }

        @Override
        public void onSuccess(@NonNull List<Country> countries) {
          hideProgress();

          CountryStore.get().countries.set(countries);

          if (countries.size() > 0) {
            openCountrySelector(countries);
          }
        }
      });
    } else {
      openCountrySelector(countries);
    }
  }

  private void openCountrySelector(List<Country> countries) {
    dialog = new CountryCodeDialog(getContext(), countries, (position, countryCode) -> {
      try {
        this.countryCode = Integer.parseInt(countryCode);
        this.textSelectedCountry.setText(String.format("+%s", countryCode));
      } catch (Exception ignored) {
      }
    }).show();
  }

  private void showProgress(String message) {
    if (getContext() instanceof BaseActivity2) {
      ((BaseActivity2) getContext()).showProgress(message);
    }
  }

  private void hideProgress() {
    if (getContext() instanceof BaseActivity2) {
      ((BaseActivity2) getContext()).hideProgress();
    }
  }

  @Override
  public void onRecycled() {
    super.onRecycled();

    hideProgress();

    if (dialog != null && dialog.isShowing()) {
      dialog.dismiss();
      dialog = null;
    }

    if (subscription != null && !subscription.isUnsubscribed()) {
      subscription.unsubscribe();
      subscription = null;
    }
  }
}
