/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout.message;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Block;
import com.zoyi.channel.plugin.android.selector.StyleSelector;
import com.zoyi.channel.plugin.android.util.DimenUtils;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.layout.message.TextBlockView;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.annimon.stream.Stream;
import java.util.List;

public class TextMessageView
extends LinearLayout {
    private static final int MODE_NORMAL = 0;
    private static final int MODE_SINGLE_VIEW = 1;
    private static final int MODE_PLAIN = 2;
    private int renderMode = 0;
    private int maxLines = Integer.MAX_VALUE;
    private int textSize = 15;
    private int bigTextSize = 54;
    private int lineSpacingExtra = 5;
    @ColorInt
    private int textColor;
    @ColorInt
    private int textLinkColor;

    public TextMessageView(Context context) {
        super(context);
        this.init(context, null);
    }

    public TextMessageView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public TextMessageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer
    private void init(Context context, @Nullable AttributeSet attrs) {
        this.setOrientation(1);
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TextMessageView, 0, 0);
            try {
                this.textColor = typedArray.getColor(R.styleable.TextMessageView_ch_tmv_textColor, StyleSelector.getTextColor());
                this.textLinkColor = typedArray.getColor(R.styleable.TextMessageView_ch_tmv_textLinkColor, StyleSelector.getTextColor());
                this.textSize = typedArray.getDimensionPixelSize(R.styleable.TextMessageView_ch_tmv_textSize, DimenUtils.spToPx(context, this.textSize));
                this.bigTextSize = typedArray.getDimensionPixelSize(R.styleable.TextMessageView_ch_tmv_bigTextSize, DimenUtils.spToPx(context, this.bigTextSize));
                this.lineSpacingExtra = typedArray.getDimensionPixelSize(R.styleable.TextMessageView_ch_tmv_lineSpacingExtra, this.lineSpacingExtra);
                this.renderMode = typedArray.getInt(R.styleable.TextMessageView_ch_tmv_renderMode, this.renderMode);
                this.maxLines = typedArray.getInt(R.styleable.TextMessageView_ch_tmv_maxLines, this.maxLines);
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public void setBlocks(@NonNull List<Block> blocks) {
        this.removeAllViews();
        switch (this.renderMode) {
            case 0: {
                this.renderNormal(blocks);
                break;
            }
            case 1: 
            case 2: {
                this.renderSingle(blocks);
            }
        }
    }

    private void renderNormal(@NonNull List<Block> blocks) {
        for (Block block : blocks) {
            Optional.ofNullable((Object)block.getType()).ifPresent(type -> {
                switch (block.getType()) {
                    case "text": 
                    case "code": {
                        this.addTextBlock(block);
                        break;
                    }
                    case "bullets": {
                        this.addBulletsBlock(block);
                    }
                }
            });
        }
    }

    private void renderSingle(@NonNull List<Block> blocks) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
        for (Block block : blocks) {
            if (spannableStringBuilder.length() > 0) {
                spannableStringBuilder.append((CharSequence)"\n");
            }
            Optional.ofNullable((Object)block.getType()).ifPresent(type -> {
                switch (block.getType()) {
                    case "text": 
                    case "code": {
                        Optional.ofNullable((Object)block.getFormattedSpanMessage()).ifPresentOrElse(arg_0 -> ((SpannableStringBuilder)spannableStringBuilder).append(arg_0), () -> spannableStringBuilder.append((CharSequence)"\n"));
                        break;
                    }
                    case "bullets": {
                        Stream.ofNullable(block.getBlocks()).forEach(textBlock -> {
                            spannableStringBuilder.append((CharSequence)"\u2022 ");
                            spannableStringBuilder.append((CharSequence)textBlock.getFormattedSpanMessage());
                            spannableStringBuilder.append((CharSequence)"\n");
                        });
                    }
                }
            });
        }
        this.addTextBlock(null, (CharSequence)spannableStringBuilder, false);
    }

    public void setText(@NonNull CharSequence text) {
        this.removeAllViews();
        if (text instanceof String) {
            Stream.of((Object[])text.toString().split("\n")).forEach(stringBlock -> this.addTextBlock(null, (CharSequence)stringBlock, false));
        } else {
            this.addTextBlock(null, text, false);
        }
    }

    private void addTextBlock(Block block) {
        CharSequence charSequence = (CharSequence)Optional.ofNullable((Object)block.getFormattedSpanMessage()).orElse(null);
        this.addTextBlock(null, charSequence, block.hasOnlyEmoji());
    }

    private void addBulletsBlock(Block block) {
        Stream.ofNullable(block.getBlocks()).filter(textBlock -> "text".equals(textBlock.getType()) && textBlock.getFormattedSpanMessage() != null).map(Block::getFormattedSpanMessage).forEach(formattedSpanMessage -> this.addTextBlock("\u2022 ", (CharSequence)formattedSpanMessage, false));
    }

    private void addTextBlock(@Nullable String prefix, CharSequence charSequence, boolean bigText) {
        this.addView((View)new TextBlockView(this.getContext()).setPrefix(prefix).setTextSize(bigText ? this.bigTextSize : this.textSize).setLineSpacingExtra(this.lineSpacingExtra).setTextColor(this.textColor).setTextLinkColor(this.textLinkColor).setPlainText(this.renderMode == 2).setMaxLines(this.maxLines).build(charSequence));
    }
}

