package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.util.AttributeSet;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.MarketingAction;
import com.zoyi.channel.plugin.android.model.entity.Previewable;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.view.media_thumbnail.FullScreenPopUpMediaThumbnailView;

import java.util.Locale;

public class FullScreenPushView extends BasePushView {

  public FullScreenPushView(@NonNull Context context) {
    super(context);
  }

  public FullScreenPushView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public FullScreenPushView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  private TextView textPopUpTime;

  @Override
  protected int getLayoutId() {
    return R.layout.ch_plugin_view_push_full_screen;
  }

  @Override
  protected void init(Context context) {
    super.init(context);

    textPopUpTime = root.findViewById(R.id.ch_textPopUpTime);
    ((FullScreenPopUpMediaThumbnailView) viewPopUpMedia).setOnFullScreenPopUpClickListener(() -> {
      if (item != null) {
        MarketingAction.sendClickEvent(item.getMarketing());
      }
    });
  }

  @Override
  public void show(Message message) {
    super.show(message);
    MarketingAction.sendViewEvent(message.getMarketing());
  }

  @Override
  protected void bindContent(Message message) {
    super.bindContent(message);

    textPopUpTime.setText(TimeUtils.getTime(message.getCreatedAt()));
  }

  @Override
  protected void setMediaSize(Previewable previewable) {
    if (previewable.getHeight() != 0) {
      float maxRatio = 16f / 9f;
      float minRatio = 1f;
      float ratio = previewable.getWidth() / previewable.getHeight();

      ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams) viewPopUpMedia.getLayoutParams();

      if (ratio < minRatio) {
        params.dimensionRatio = "H,1:1";
      } else if (ratio > maxRatio) {
        params.dimensionRatio = "H,16:9";
      } else {
        params.dimensionRatio = String.format(Locale.ENGLISH, "H,%d:%d", previewable.getWidth(), previewable.getHeight());
      }
    }
  }

  @Override
  public void resetView() {
    super.resetView();
  }

  @Override
  protected int getDefaultTextMaxLine() {
    return 8;
  }

  @Override
  protected int getAttachmentTextMaxLine() {
    return 4;
  }
}
