package com.zoyi.channel.plugin.android.util;

import android.support.annotation.Nullable;

import java.util.Locale;

public class FormatUtils {

  @Nullable
  public static String formatDuration(@Nullable Long durationMilliseconds) {
    if (durationMilliseconds == null || durationMilliseconds == 0L) {
      return null;
    }

    long durationSeconds = durationMilliseconds / 1000;
    long hours = durationSeconds / 3600;
    long minutes = (durationSeconds % 3600) / 60;
    long seconds = durationSeconds % 60;

    if (hours > 0) {
      return String.format(Locale.ENGLISH, "%d:%02d:%02d", hours, minutes, seconds);
    }
    return String.format(Locale.ENGLISH, "%d:%02d", minutes, seconds);
  }

  public static String formatFileSize(long bytes) {
    if (bytes < 1000) {
      return String.format(Locale.US, "%dB", bytes);
    } else if (bytes <= 1000000) {
      return String.format(Locale.US, "%.1fKB", bytes / 1000.0);
    } else if (bytes <= 1000000000) {
      return String.format(Locale.US, "%.1fMB", bytes / 1000000.0);
    } else {
      return String.format(Locale.US, "%.1fGB", bytes / 1000000000.0);
    }
  }
}
