package com.zoyi.channel.plugin.android.activity.chat.view.viewholder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.CardView;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.ProfileBot;
import com.zoyi.channel.plugin.android.util.ProfileUtils;

public class ProfileBotCompleteView extends CardView {

  private TextView textLabel;
  private TextView textValue;

  public ProfileBotCompleteView(@NonNull Context context) {
    super(context);

    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_item_message_profile_bot_complete_view, this, true);

    textLabel = view.findViewById(R.id.textProfileBotItemCompleteLabel);
    textValue = view.findViewById(R.id.textProfileBotItemCompleteValue);
  }

  public void bind(ProfileBot profileBot) {
    textLabel.setText(profileBot.getName());
    textValue.setText(ProfileUtils.getFormattedString(profileBot.getValue()));
  }
}
