/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint.network.http;

import com.splunk.mint.network.MonitorRegistry;
import com.splunk.mint.network.http.MonitorableHttpsURLConnection;
import com.splunk.mint.network.http.URLStreamHandlerBase;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;

public class HTTPSURLStreamHandler
extends URLStreamHandlerBase {
    private static final String[] SYSTEM_CLASSES = new String[]{"libcore.net.http.HttpsURLConnectionImpl", "org.apache.harmony.luni.internal.net.www.protocol.http.HttpsURLConnectionImpl", "org.apache.harmony.luni.internal.net.www.protocol.http.HttpsURLConnection"};
    private static final int PORT = 443;
    private static final String PROTOCOL = "https";
    private final MonitorRegistry registry;

    public HTTPSURLStreamHandler(MonitorRegistry registry) throws ClassNotFoundException {
        super(SYSTEM_CLASSES);
        this.registry = registry;
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        URLConnection openConnection = super.openConnection(url);
        return new MonitorableHttpsURLConnection(this.registry, openConnection);
    }

    @Override
    protected URLConnection openConnection(URL url, Proxy proxy) throws IOException {
        URLConnection openConnection = super.openConnection(url, proxy);
        return new MonitorableHttpsURLConnection(this.registry, openConnection);
    }

    @Override
    public int getDefaultPort() {
        return 443;
    }

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }
}

