/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.LauncherConfig;

public class ChannelPluginSettings {
    @Nullable
    private String pluginKey;
    @Nullable
    private String memberId;
    @Nullable
    private String memberHash;
    private boolean debugMode;
    private boolean enabledTrackDefaultEvent;
    private boolean hideDefaultInAppPush;
    @Nullable
    private Boolean unsubscribed;
    @Nullable
    private CHLocale locale;
    @Nullable
    private LauncherConfig launcherConfig;

    public ChannelPluginSettings(@Nullable String pluginKey) {
        this.pluginKey = pluginKey;
        this.debugMode = false;
        this.enabledTrackDefaultEvent = true;
        this.hideDefaultInAppPush = false;
        this.locale = null;
    }

    public static ChannelPluginSettings create(@Nullable String pluginKey) {
        return new ChannelPluginSettings(pluginKey);
    }

    public void setPluginKey(@Nullable String pluginKey) {
        this.pluginKey = pluginKey;
    }

    public ChannelPluginSettings setMemberId(@Nullable String memberId) {
        this.memberId = memberId;
        return this;
    }

    public ChannelPluginSettings setMemberHash(@Nullable String memberHash) {
        this.memberHash = memberHash;
        return this;
    }

    public ChannelPluginSettings setUnsubscribed(boolean unsubscribed) {
        this.unsubscribed = unsubscribed;
        return this;
    }

    public ChannelPluginSettings setDebugMode(@Nullable Boolean debug) {
        if (debug != null) {
            this.debugMode = debug;
        }
        return this;
    }

    public ChannelPluginSettings setEnabledTrackDefaultEvent(@Nullable Boolean enabledTrackDefaultEvent) {
        if (enabledTrackDefaultEvent != null) {
            this.enabledTrackDefaultEvent = enabledTrackDefaultEvent;
        }
        return this;
    }

    public ChannelPluginSettings setHideDefaultInAppPush(@Nullable Boolean hideDefaultInAppPush) {
        if (hideDefaultInAppPush != null) {
            this.hideDefaultInAppPush = hideDefaultInAppPush;
        }
        return this;
    }

    public ChannelPluginSettings setLocale(@Nullable CHLocale locale) {
        this.locale = locale;
        return this;
    }

    public ChannelPluginSettings setLauncherConfig(@Nullable LauncherConfig launcherConfig) {
        this.launcherConfig = launcherConfig;
        return this;
    }

    @Nullable
    public String getPluginKey() {
        return this.pluginKey;
    }

    @Nullable
    public String getMemberId() {
        return this.memberId;
    }

    @Nullable
    public String getMemberHash() {
        return this.memberHash;
    }

    @Nullable
    public Boolean getUnsubscribed() {
        return this.unsubscribed;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isEnabledTrackDefaultEvent() {
        return this.enabledTrackDefaultEvent;
    }

    public boolean isHideDefaultInAppPush() {
        return this.hideDefaultInAppPush;
    }

    @NonNull
    public CHLocale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return CHLocale.getDeviceLocale();
    }

    @Nullable
    public LauncherConfig getLauncherConfig() {
        return this.launcherConfig;
    }
}

