package com.zoyi.channel.plugin.android.network;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.okhttp3.Interceptor;
import com.zoyi.okhttp3.Request;
import com.zoyi.okhttp3.Response;

import java.io.IOException;

/**
 * Created by mika on 2016. 3. 14..
 */
public class RetrofitInterceptor implements Interceptor {
  @Override
  public Response intercept(Chain chain) throws IOException {
    Request request = chain.request();

    Request.Builder builder = request.newBuilder();

    String jwt = GlobalStore.get().jwt.get();

    // if jwt is null, if will not booted yet, so get latest jwt from preference
    if (jwt != null && ChannelIO.getAppContext() != null) {
      L.e("PushTest: jwt is null, handle");
      jwt = PrefSupervisor.getJwt(ChannelIO.getAppContext());
    }

    if (jwt != null) {
      L.e("PushTest: jwt: " + jwt);
      builder.header(Const.X_SESSION, jwt);
    } else {
      L.e("PushTest: jwt is null");
    }

    return chain.proceed(builder.build());
  }
}
