package com.zoyi.channel.plugin.android.model.rest;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.UpdatableEntity;

/**
 * Created by mika on 2016. 12. 6..
 */
public class UserChat implements Entity, UpdatableEntity {
  private String id;
  @Nullable
  private String channelId;
  @Nullable
  private String state;
  @Nullable
  private Long frontUpdatedAt;
  @Nullable
  private Long closedAt;
  @Nullable
  private String frontMessageId;
  @Nullable
  private String assigneeId;
  @Nullable
  private String review;
  @Nullable
  private String handling;

  @Override
  public String getId() {
    return id;
  }

  @Nullable
  public String getState() {
    return state;
  }

  public boolean isStateSolved() {
    return !TextUtils.isEmpty(state) && Const.USER_CHAT_STATE_SOLVED.equals(state);
  }

  public boolean isStateClosed() {
    return !TextUtils.isEmpty(state) && Const.USER_CHAT_STATE_CLOSED.equals(state);
  }

  public boolean isSupporting() {
    return Const.USER_CHAT_HANDLING_SUPPORT.equals(handling);
  }

  public boolean isStateRemoved() {
    return !TextUtils.isEmpty(state) && Const.USER_CHAT_STATE_REMOVED.equals(state);
  }

  @Nullable
  @Override
  public Long getUpdatedAt() {
    return frontUpdatedAt;
  }

  @Nullable
  public String getAssigneeId() {
    return assigneeId;
  }

  @Nullable
  public String getReview() {
    return review;
  }

  @Nullable
  public Long getClosedAt() {
    return closedAt;
  }

  public final static String CLASSNAME = "userChat";
}
