/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util.unsafe;

import com.zoyi.rx.internal.util.SuppressAnimalSniffer;
import com.zoyi.rx.internal.util.unsafe.SpmcArrayQueueL3Pad;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressAnimalSniffer
public final class SpmcArrayQueue<E>
extends SpmcArrayQueueL3Pad<E> {
    public SpmcArrayQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        Object[] lb = this.buffer;
        long lMask = this.mask;
        long currProducerIndex = this.lvProducerIndex();
        long offset = this.calcElementOffset(currProducerIndex);
        if (null != this.lvElement(lb, offset)) {
            long size = currProducerIndex - this.lvConsumerIndex();
            if (size > lMask) {
                return false;
            }
            while (null != this.lvElement(lb, offset)) {
            }
        }
        this.spElement(lb, offset, e);
        this.soTail(currProducerIndex + 1L);
        return true;
    }

    @Override
    public E poll() {
        long currentConsumerIndex;
        long currProducerIndexCache = this.lvProducerIndexCache();
        do {
            if ((currentConsumerIndex = this.lvConsumerIndex()) < currProducerIndexCache) continue;
            long currProducerIndex = this.lvProducerIndex();
            if (currentConsumerIndex >= currProducerIndex) {
                return null;
            }
            this.svProducerIndexCache(currProducerIndex);
        } while (!this.casHead(currentConsumerIndex, currentConsumerIndex + 1L));
        long offset = this.calcElementOffset(currentConsumerIndex);
        Object[] lb = this.buffer;
        Object e = this.lpElement(lb, offset);
        this.soElement(lb, offset, null);
        return (E)e;
    }

    @Override
    public E peek() {
        long currentConsumerIndex;
        Object e;
        long currProducerIndexCache = this.lvProducerIndexCache();
        do {
            if ((currentConsumerIndex = this.lvConsumerIndex()) < currProducerIndexCache) continue;
            long currProducerIndex = this.lvProducerIndex();
            if (currentConsumerIndex >= currProducerIndex) {
                return null;
            }
            this.svProducerIndexCache(currProducerIndex);
        } while (null == (e = this.lvElement(this.calcElementOffset(currentConsumerIndex))));
        return e;
    }

    @Override
    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    @Override
    public boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }
}

