/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.com.bumptech.glide.load.resource.gif;

import android.graphics.Bitmap;
import android.util.Log;
import com.zoyi.com.bumptech.glide.gifdecoder.GifDecoder;
import com.zoyi.com.bumptech.glide.gifdecoder.GifHeader;
import com.zoyi.com.bumptech.glide.gifdecoder.GifHeaderParser;
import com.zoyi.com.bumptech.glide.gifencoder.AnimatedGifEncoder;
import com.zoyi.com.bumptech.glide.load.ResourceEncoder;
import com.zoyi.com.bumptech.glide.load.Transformation;
import com.zoyi.com.bumptech.glide.load.engine.Resource;
import com.zoyi.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.zoyi.com.bumptech.glide.load.resource.UnitTransformation;
import com.zoyi.com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.zoyi.com.bumptech.glide.load.resource.gif.GifBitmapProvider;
import com.zoyi.com.bumptech.glide.load.resource.gif.GifDrawable;
import com.zoyi.com.bumptech.glide.util.LogTime;
import java.io.IOException;
import java.io.OutputStream;

public class GifResourceEncoder
implements ResourceEncoder<GifDrawable> {
    private static final Factory FACTORY = new Factory();
    private static final String TAG = "GifEncoder";
    private final GifDecoder.BitmapProvider provider;
    private final BitmapPool bitmapPool;
    private final Factory factory;

    public GifResourceEncoder(BitmapPool bitmapPool) {
        this(bitmapPool, FACTORY);
    }

    GifResourceEncoder(BitmapPool bitmapPool, Factory factory) {
        this.bitmapPool = bitmapPool;
        this.provider = new GifBitmapProvider(bitmapPool);
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean encode(Resource<GifDrawable> resource, OutputStream os) {
        long startTime = LogTime.getLogTime();
        GifDrawable drawable = resource.get();
        Transformation<Bitmap> transformation = drawable.getFrameTransformation();
        if (transformation instanceof UnitTransformation) {
            return this.writeDataDirect(drawable.getData(), os);
        }
        GifDecoder decoder = this.decodeHeaders(drawable.getData());
        AnimatedGifEncoder encoder = this.factory.buildEncoder();
        if (!encoder.start(os)) {
            return false;
        }
        for (int i = 0; i < decoder.getFrameCount(); ++i) {
            Bitmap currentFrame = decoder.getNextFrame();
            Resource<Bitmap> transformedResource = this.getTransformedFrame(currentFrame, transformation, drawable);
            try {
                if (!encoder.addFrame(transformedResource.get())) {
                    boolean bl = false;
                    return bl;
                }
                int currentFrameIndex = decoder.getCurrentFrameIndex();
                int delay = decoder.getDelay(currentFrameIndex);
                encoder.setDelay(delay);
                decoder.advance();
                continue;
            }
            finally {
                transformedResource.recycle();
            }
        }
        boolean result = encoder.finish();
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Encoded gif with " + decoder.getFrameCount() + " frames and " + drawable.getData().length + " bytes in " + LogTime.getElapsedMillis(startTime) + " ms"));
        }
        return result;
    }

    private boolean writeDataDirect(byte[] data, OutputStream os) {
        boolean success = true;
        try {
            os.write(data);
        }
        catch (IOException e) {
            if (Log.isLoggable((String)TAG, (int)3)) {
                Log.d((String)TAG, (String)"Failed to write data to output stream in GifResourceEncoder", (Throwable)e);
            }
            success = false;
        }
        return success;
    }

    private GifDecoder decodeHeaders(byte[] data) {
        GifHeaderParser parser = this.factory.buildParser();
        parser.setData(data);
        GifHeader header = parser.parseHeader();
        GifDecoder decoder = this.factory.buildDecoder(this.provider);
        decoder.setData(header, data);
        decoder.advance();
        return decoder;
    }

    private Resource<Bitmap> getTransformedFrame(Bitmap currentFrame, Transformation<Bitmap> transformation, GifDrawable drawable) {
        Resource<Bitmap> transformedResource;
        Resource<Bitmap> bitmapResource = this.factory.buildFrameResource(currentFrame, this.bitmapPool);
        if (!bitmapResource.equals(transformedResource = transformation.transform(bitmapResource, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight()))) {
            bitmapResource.recycle();
        }
        return transformedResource;
    }

    @Override
    public String getId() {
        return "";
    }

    static class Factory {
        Factory() {
        }

        public GifDecoder buildDecoder(GifDecoder.BitmapProvider bitmapProvider) {
            return new GifDecoder(bitmapProvider);
        }

        public GifHeaderParser buildParser() {
            return new GifHeaderParser();
        }

        public AnimatedGifEncoder buildEncoder() {
            return new AnimatedGifEncoder();
        }

        public Resource<Bitmap> buildFrameResource(Bitmap bitmap, BitmapPool bitmapPool) {
            return new BitmapResource(bitmap, bitmapPool);
        }
    }
}

