/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.push;

import android.content.Context;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.store.UserStore;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.com.annimon.stream.Optional;

public class ChannelPushClient {
    public static void handlePushNotification(Context context) {
        ChannelPushManager.clearNotification(context);
        if (PrefSupervisor.hasLatestPushData(context) && PrefSupervisor.hasLatestBootData(context)) {
            if (ChannelIO.isBooted()) {
                if (!ChannelPushClient.launchChat(context)) {
                    L.e("Push Notification : Channel or user does not match for latest push notification");
                }
            } else if (ChannelIO.isInitializedChannelIO()) {
                String pluginKey = PrefSupervisor.getLatestPluginKey(context);
                String pushChatId = ChannelPushClient.getValidPushNotificationChatId(context, PrefSupervisor.getLatestBootedChannelId(context), PrefSupervisor.getLatestBootedUserId(context));
                if (pluginKey != null && pushChatId != null) {
                    ChannelPluginSettings pluginSettings = new ChannelPluginSettings(pluginKey);
                    ChannelIO.boot(pluginSettings, (status, user) -> {
                        switch (status) {
                            case SUCCESS: {
                                ChannelPushClient.launchChat(context);
                                break;
                            }
                            case NOT_INITIALIZED: {
                                L.e("Push Notification : This plugin is Not initialized");
                                break;
                            }
                            case NETWORK_TIMEOUT: {
                                L.e("Push Notification : Network timeout error!");
                                break;
                            }
                            case ACCESS_DENIED: {
                                L.e("Push Notification : Access denied!");
                                break;
                            }
                            case REQUIRE_PAYMENT: {
                                L.e("Push Notification : Require payment!");
                                break;
                            }
                            case NOT_AVAILABLE_VERSION: {
                                L.e("Push Notification : Check Plugin version");
                                break;
                            }
                            case SERVICE_UNDER_CONSTRUCTION: {
                                L.e("Push Notification : Service is now under construction");
                                break;
                            }
                            default: {
                                L.e("Push Notification : Unknown error");
                            }
                        }
                    });
                } else {
                    L.e("Push Notification : Latest booted plugin key is not exists or Channel or user does not match for latest push notification");
                }
            } else {
                L.e("Push Notification : Please initialize ChannelIO first");
            }
        }
    }

    @Nullable
    public static String getValidPushNotificationChatId(@Nullable Context context, @Nullable String channelId, @Nullable String userId) {
        String pushChannelId = PrefSupervisor.getLatestPushChannelId(context);
        String pushUserId = PrefSupervisor.getLatestPushUserId(context);
        String pushChatId = PrefSupervisor.getLatestPushChatId(context);
        if (channelId != null && userId != null && channelId.equals(pushChannelId) && userId.equals(pushUserId)) {
            return pushChatId;
        }
        return null;
    }

    public static boolean launchChat(Context context) {
        String currentChannelId = (String)Optional.ofNullable((Object)ChannelStore.get().channelState.get()).map(Channel::getId).orElse(null);
        String currentUserId = (String)Optional.ofNullable((Object)UserStore.get().user.get()).map(User::getId).orElse(null);
        String pushChatId = ChannelPushClient.getValidPushNotificationChatId(context, currentChannelId, currentUserId);
        PrefSupervisor.clearLatestPushData(context);
        if (pushChatId != null) {
            ChannelIO.openChat(context, pushChatId);
            return true;
        }
        return false;
    }
}

