/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Func0;
import com.zoyi.rx.observers.SerializedSubscriber;
import com.zoyi.rx.observers.Subscribers;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperatorBufferWithSingleObservable<T, TClosing>
implements Observable.Operator<List<T>, T> {
    final Func0<? extends Observable<? extends TClosing>> bufferClosingSelector;
    final int initialCapacity;

    public OperatorBufferWithSingleObservable(Func0<? extends Observable<? extends TClosing>> bufferClosingSelector, int initialCapacity) {
        this.bufferClosingSelector = bufferClosingSelector;
        this.initialCapacity = initialCapacity;
    }

    public OperatorBufferWithSingleObservable(final Observable<? extends TClosing> bufferClosing, int initialCapacity) {
        this.bufferClosingSelector = new Func0<Observable<? extends TClosing>>(){

            @Override
            public Observable<? extends TClosing> call() {
                return bufferClosing;
            }
        };
        this.initialCapacity = initialCapacity;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super List<T>> child) {
        Observable<TClosing> closing;
        try {
            closing = this.bufferClosingSelector.call();
        }
        catch (Throwable t) {
            Exceptions.throwOrReport(t, child);
            return Subscribers.empty();
        }
        final BufferingSubscriber s = new BufferingSubscriber(new SerializedSubscriber<List<T>>(child));
        Subscriber closingSubscriber = new Subscriber<TClosing>(){

            @Override
            public void onNext(TClosing t) {
                s.emit();
            }

            @Override
            public void onError(Throwable e) {
                s.onError(e);
            }

            @Override
            public void onCompleted() {
                s.onCompleted();
            }
        };
        child.add(closingSubscriber);
        child.add(s);
        closing.unsafeSubscribe(closingSubscriber);
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class BufferingSubscriber
    extends Subscriber<T> {
        final Subscriber<? super List<T>> child;
        List<T> chunk;
        boolean done;

        public BufferingSubscriber(Subscriber<? super List<T>> child) {
            this.child = child;
            this.chunk = new ArrayList(OperatorBufferWithSingleObservable.this.initialCapacity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            BufferingSubscriber bufferingSubscriber = this;
            synchronized (bufferingSubscriber) {
                if (this.done) {
                    return;
                }
                this.chunk.add(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(Throwable e) {
            BufferingSubscriber bufferingSubscriber = this;
            synchronized (bufferingSubscriber) {
                if (this.done) {
                    return;
                }
                this.done = true;
                this.chunk = null;
            }
            this.child.onError(e);
            this.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCompleted() {
            try {
                List toEmit;
                BufferingSubscriber bufferingSubscriber = this;
                synchronized (bufferingSubscriber) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                    toEmit = this.chunk;
                    this.chunk = null;
                }
                this.child.onNext(toEmit);
            }
            catch (Throwable t) {
                Exceptions.throwOrReport(t, this.child);
                return;
            }
            this.child.onCompleted();
            this.unsubscribe();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void emit() {
            List toEmit;
            BufferingSubscriber bufferingSubscriber = this;
            synchronized (bufferingSubscriber) {
                if (this.done) {
                    return;
                }
                toEmit = this.chunk;
                this.chunk = new ArrayList(OperatorBufferWithSingleObservable.this.initialCapacity);
            }
            try {
                this.child.onNext(toEmit);
            }
            catch (Throwable t) {
                this.unsubscribe();
                BufferingSubscriber bufferingSubscriber2 = this;
                synchronized (bufferingSubscriber2) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                }
                Exceptions.throwOrReport(t, this.child);
            }
        }
    }
}

