package com.zoyi.channel.plugin.android.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.webview.CHWebViewActivity;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Const;

/**
 * Created by mika on 2016. 4. 6..
 */
public class IntentUtils {
  @Nullable
  private Context context;
  @Nullable
  private Intent intent;
  private Transition transition = Transition.SLIDE_FROM_RIGHT;

  public static IntentUtils setNextActivity(@Nullable Context context, @Nullable Class<?> clazz) {
    IntentUtils intentUtils = new IntentUtils();
    intentUtils.context = context;
    intentUtils.intent = new Intent(context, clazz);
    return intentUtils;
  }

  public IntentUtils() {
  }

  private IntentUtils(@Nullable Context context, @Nullable Intent intent) {
    this.context = context;
    this.intent = intent;
  }

  public IntentUtils putExtra(String key, @Nullable Integer value) {
    if (intent != null && value != null) {
      intent.putExtra(key, value);
    }
    return this;
  }

  public IntentUtils putExtra(String key, @Nullable Long value) {
    if (intent != null && value != null) {
      intent.putExtra(key, value);
    }
    return this;
  }

  public IntentUtils putExtra(String key, @Nullable String value) {
    if (intent != null && value != null) {
      intent.putExtra(key, value);
    }
    return this;
  }

  public IntentUtils putExtra(String key, @Nullable Boolean value) {
    if (intent != null && value != null) {
      intent.putExtra(key, value);
    }
    return this;
  }

  public IntentUtils putExtra(String key, @Nullable Parcelable value) {
    if (intent != null && value != null) {
      intent.putExtra(key, value);
    }
    return this;
  }

  public IntentUtils setTransition(Transition transition) {
    this.transition = transition;
    return this;
  }

  public IntentUtils setFlag(int flags) {
    if (intent != null) {
      intent.setFlags(flags);
    }
    return this;
  }

  public void startActivity() {
    if (context != null && intent != null) {
      try {
        context.startActivity(intent);
        if (context instanceof Activity) {
          setActivityTransition((Activity) context);
        }
      } catch (Exception ex) {
      }
    }
  }

  public void startActivityForResult(int requestCode) {
    if (context instanceof Activity && intent != null) {
      intent.putExtra(Const.REQUEST_CODE_INTENT_KEY, requestCode);
      ((Activity) context).startActivityForResult(intent, requestCode);
      setActivityTransition((Activity) context);
    }
  }

  private void setActivityTransition(Activity activity) {
    switch (transition) {
      case NONE:
        activity.overridePendingTransition(R.anim.ch_plugin_idle, R.anim.ch_plugin_idle);
        break;

      case SLIDE_FROM_RIGHT:
        activity.overridePendingTransition(R.anim.ch_plugin_slide_in_right, R.anim.ch_plugin_idle);
        break;

      case SLIDE_FROM_BOTTOM:
        activity.overridePendingTransition(R.anim.ch_plugin_slide_in_bottom, R.anim.ch_plugin_idle);
        break;
    }
  }

  public static IntentUtils setUrl(Context context, String url) {
    return IntentUtils.setNextActivity(context, CHWebViewActivity.class).putExtra(Const.EXTRA_URL, url);
  }

  public static IntentUtils setApp(Context context, String url) {
    Uri uri;
    try {
      uri =  Uri.parse(url);
    } catch (Exception ignored) {
      return new IntentUtils(context, null);
    }
    return new IntentUtils(context, new Intent(Intent.ACTION_VIEW, uri));
  }

  public static IntentUtils setEmail(Context context, String email) {
    Uri uri;
    try {
      uri = Uri.parse(String.format("mailto:%s", email));
    } catch (Exception ignored) {
      return new IntentUtils(context, null);
    }
    return new IntentUtils(context, new Intent(Intent.ACTION_SENDTO, uri));
  }

  public static IntentUtils setPhone(Context context, String phoneNumber) {
    Uri uri;
    try {
      uri = Uri.parse(String.format("tel:%s", phoneNumber));
    } catch (Exception ignored) {
      return new IntentUtils(context, null);
    }
    return new IntentUtils(context, new Intent(Intent.ACTION_CALL, uri));
  }
}
