package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.graphics.Color;
import android.widget.Toast;

import com.zoyi.channel.plugin.android.R;

/**
 * Created by mika on 2016. 12. 7..
 */
public class UIUtils {

  public static void showToast(Context context, String message) {
    Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
  }

  public static int getLauncherIcon(int chatCount, int textColor, boolean hasMarketingChat) {

    boolean hasLauncherStroke = textColor == Color.BLACK;

    if (hasLauncherStroke) {
      if (hasMarketingChat) {
        return R.drawable.bubble_stroke_push;
      }

      if (chatCount <= 0) {
        return R.drawable.bubble_stroke;
      } else if (chatCount < 10) {
        return R.drawable.bubble_stroke_up;
      } else {
        return R.drawable.bubble_stroke_up_right;
      }
    } else {
      if (hasMarketingChat) {
        return R.drawable.bubble_filled_push;
      }

      if (chatCount <= 0) {
        return R.drawable.bubble_filled;
      } else if (chatCount < 10) {
        return R.drawable.bubble_filled_up;
      } else {
        return R.drawable.bubble_filled_up_right;
      }
    }
  }
}
