package com.zoyi.channel.plugin.android.base;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.contract.BasePresenter;
import com.zoyi.channel.plugin.android.contract.BaseView;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.rx.Subscription;

import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPresenter<V extends BaseView> implements BasePresenter {

  protected V view;

  @Nullable
  private List<Binder> binders;

  @Nullable
  private Subscription subscription;

  public AbstractPresenter(V view) {
    this.view = view;

    this.subscription = Action.observable().subscribe(actionType -> {
      handleBaseAction(actionType);
      handleAction(actionType);
    });
  }

  protected void bind(Binder binder) {
    if (binders == null) {
      binders = new ArrayList<>();
    }
    binders.add(binder);
  }

  public abstract void init();

  private void handleBaseAction(ActionType actionType) {
    switch (actionType) {
      case EXIT:
        view.finish(Transition.SLIDE_FROM_BOTTOM);
        break;

      case SHUTDOWN:
        view.finish(Transition.NONE);
        break;
    }
  }

  protected void handleAction(ActionType actionType) {
  }

  public void release() {
    if (binders != null) {
      for (Binder binder : binders) {
        if (binder != null) {
          binder.unbind();
        }
      }
      binders.clear();
      binders = null;
    }
    if (subscription != null && !subscription.isUnsubscribed()) {
      subscription.unsubscribe();
      subscription = null;
    }
  }
}
