/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.rest;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.TimeRange;
import com.zoyi.com.annimon.stream.Stream;
import java.util.List;

public class Channel
implements Entity,
ProfileEntity {
    public static final String EXPECTED_RESPONSE_DELAY_INSTANT = "instant";
    public static final String EXPECTED_RESPONSE_DELAY_NORMAL = "normal";
    public static final String EXPECTED_RESPONSE_DELAY_DELAYED = "delayed";
    public static final String PLAN_PRO = "pro";
    private String id;
    private String name;
    @Nullable
    private String domain;
    @Nullable
    private String description;
    @Nullable
    private String timeZone;
    @Nullable
    private List<TimeRange> workingTimeRanges;
    @Nullable
    private String homepageUrl;
    @Nullable
    private String phoneNumber;
    @Nullable
    private String messengerPlan;
    @Nullable
    private Boolean blocked;
    @Nullable
    private String expectedResponseDelay;
    @Nullable
    private String workingType;
    @Nullable
    private String awayOption;
    @Nullable
    private Boolean trial;
    @Nullable
    private String avatarUrl;
    @Nullable
    private String utcOffset;
    @Nullable
    private String defaultPluginId;
    @Nullable
    private String state;
    public static final String CLASSNAME = "channel";

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name != null ? this.name : "";
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getAwayOption() {
        return this.awayOption;
    }

    @Nullable
    public String getWorkingType() {
        return this.workingType;
    }

    @Override
    @Nullable
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public String getWorkingTimeText() {
        if (this.workingTimeRanges != null) {
            String work = TextUtils.join((CharSequence)"\n", (Iterable)Stream.ofNullable(this.workingTimeRanges).map(TimeRange::getMessage).toList());
            return String.format("%s\n\nTimezone: %s", work, this.timeZone);
        }
        return "";
    }

    @Nullable
    public List<TimeRange> getWorkingTimeRanges() {
        if ("custom".equals(this.workingType) && this.hasValidWorkingTime()) {
            return this.workingTimeRanges;
        }
        return null;
    }

    public boolean hasValidWorkingTime() {
        if (!"custom".equals(this.workingType)) {
            return false;
        }
        if (this.workingTimeRanges == null) {
            return false;
        }
        return Stream.ofNullable(this.workingTimeRanges).filter(TimeRange::isValid).count() > 0L;
    }

    public long getUtcOffsetMinutes() {
        try {
            if (this.utcOffset != null) {
                String[] split = this.utcOffset.split(":");
                long hours = Long.valueOf(split[0]);
                long minutes = Long.valueOf(split[1]);
                int sign = hours < 0L ? -1 : 1;
                return (hours * (long)sign * 60L + minutes) * (long)sign;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    @Nullable
    public String getHomepageUrl() {
        return this.homepageUrl;
    }

    @Nullable
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Nullable
    public String getMessengerPlan() {
        return this.messengerPlan;
    }

    @Nullable
    public String getExpectedResponseDelay() {
        return this.expectedResponseDelay;
    }

    public boolean isTrial() {
        if (this.trial == null) {
            return false;
        }
        return this.trial;
    }

    public boolean isProMessengerPlan() {
        return PLAN_PRO.equals(this.getMessengerPlan());
    }

    public boolean isBlocked() {
        if (this.blocked != null) {
            return this.blocked;
        }
        return true;
    }

    public boolean canUseMobileSdk() {
        return !this.isBlocked() && (this.isTrial() || this.isProMessengerPlan());
    }

    public boolean isUnpaid() {
        return "unpaid".equals(this.state);
    }

    @Nullable
    public String getDefaultPluginId() {
        return this.defaultPluginId;
    }
}

