/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.util;

import com.zoyi.rx.Notification;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Scheduler;
import com.zoyi.rx.exceptions.OnErrorNotImplementedException;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action2;
import com.zoyi.rx.functions.Func0;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.functions.Func2;
import com.zoyi.rx.internal.operators.OperatorAny;
import com.zoyi.rx.internal.util.UtilityFunctions;
import com.zoyi.rx.observables.ConnectableObservable;
import java.util.List;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InternalObservableUtils {

    public static final PlusOneLongFunc2 LONG_COUNTER = new PlusOneLongFunc2();
    public static final ObjectEqualsFunc2 OBJECT_EQUALS = new ObjectEqualsFunc2();
    public static final ToArrayFunc1 TO_ARRAY = new ToArrayFunc1();
    static final ReturnsVoidFunc1 RETURNS_VOID = new ReturnsVoidFunc1();
    public static final PlusOneFunc2 COUNTER = new PlusOneFunc2();
    static final NotificationErrorExtractor ERROR_EXTRACTOR = new NotificationErrorExtractor();
    public static final Action1<Throwable> ERROR_NOT_IMPLEMENTED = new ErrorNotImplementedAction();
    public static final Observable.Operator<Boolean, Object> IS_EMPTY = new OperatorAny<Object>(UtilityFunctions.alwaysTrue(), true);

    public static Func1<Object, Boolean> equalsWith(Object other) {
        return new EqualsWithFunc1(other);
    }

    public static Func1<Object, Boolean> isInstanceOf(Class<?> clazz) {
        return new IsInstanceOfFunc1(clazz);
    }

    public static Func1<Observable<? extends Notification<?>>, Observable<?>> createRepeatDematerializer(Func1<? super Observable<? extends Void>, ? extends Observable<?>> notificationHandler) {
        return new RepeatNotificationDematerializer(notificationHandler);
    }

    public static <T, R> Func1<Observable<T>, Observable<R>> createReplaySelectorAndObserveOn(Func1<? super Observable<T>, ? extends Observable<R>> selector, Scheduler scheduler) {
        return new SelectorAndObserveOn(selector, scheduler);
    }

    public static Func1<Observable<? extends Notification<?>>, Observable<?>> createRetryDematerializer(Func1<? super Observable<? extends Throwable>, ? extends Observable<?>> notificationHandler) {
        return new RetryNotificationDematerializer(notificationHandler);
    }

    public static <T> Func0<ConnectableObservable<T>> createReplaySupplier(Observable<T> source) {
        return new ReplaySupplierNoParams<T>(source);
    }

    public static <T> Func0<ConnectableObservable<T>> createReplaySupplier(Observable<T> source, int bufferSize) {
        return new ReplaySupplierBuffer<T>(source, bufferSize);
    }

    public static <T> Func0<ConnectableObservable<T>> createReplaySupplier(Observable<T> source, long time, TimeUnit unit, Scheduler scheduler) {
        return new ReplaySupplierBufferTime<T>(source, time, unit, scheduler);
    }

    public static <T> Func0<ConnectableObservable<T>> createReplaySupplier(Observable<T> source, int bufferSize, long time, TimeUnit unit, Scheduler scheduler) {
        return new ReplaySupplierTime<T>(source, bufferSize, time, unit, scheduler);
    }

    public static <T, R> Func2<R, T, R> createCollectorCaller(Action2<R, ? super T> collector) {
        return new CollectorCaller<T, R>(collector);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ErrorNotImplementedAction
    implements Action1<Throwable> {
        ErrorNotImplementedAction() {
        }

        @Override
        public void call(Throwable t) {
            throw new OnErrorNotImplementedException(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CollectorCaller<T, R>
    implements Func2<R, T, R> {
        final Action2<R, ? super T> collector;

        public CollectorCaller(Action2<R, ? super T> collector) {
            this.collector = collector;
        }

        @Override
        public R call(R state, T value) {
            this.collector.call(state, value);
            return state;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ReplaySupplierTime<T>
    implements Func0<ConnectableObservable<T>> {
        private final long time;
        private final TimeUnit unit;
        private final Scheduler scheduler;
        private final int bufferSize;
        private final Observable<T> source;

        ReplaySupplierTime(Observable<T> source, int bufferSize, long time, TimeUnit unit, Scheduler scheduler) {
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
            this.bufferSize = bufferSize;
            this.source = source;
        }

        @Override
        public ConnectableObservable<T> call() {
            return this.source.replay(this.bufferSize, this.time, this.unit, this.scheduler);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ReplaySupplierBufferTime<T>
    implements Func0<ConnectableObservable<T>> {
        private final TimeUnit unit;
        private final Observable<T> source;
        private final long time;
        private final Scheduler scheduler;

        ReplaySupplierBufferTime(Observable<T> source, long time, TimeUnit unit, Scheduler scheduler) {
            this.unit = unit;
            this.source = source;
            this.time = time;
            this.scheduler = scheduler;
        }

        @Override
        public ConnectableObservable<T> call() {
            return this.source.replay(this.time, this.unit, this.scheduler);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ReplaySupplierBuffer<T>
    implements Func0<ConnectableObservable<T>> {
        private final Observable<T> source;
        private final int bufferSize;

        ReplaySupplierBuffer(Observable<T> source, int bufferSize) {
            this.source = source;
            this.bufferSize = bufferSize;
        }

        @Override
        public ConnectableObservable<T> call() {
            return this.source.replay(this.bufferSize);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ReplaySupplierNoParams<T>
    implements Func0<ConnectableObservable<T>> {
        private final Observable<T> source;

        ReplaySupplierNoParams(Observable<T> source) {
            this.source = source;
        }

        @Override
        public ConnectableObservable<T> call() {
            return this.source.replay();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class NotificationErrorExtractor
    implements Func1<Notification<?>, Throwable> {
        NotificationErrorExtractor() {
        }

        @Override
        public Throwable call(Notification<?> t) {
            return t.getThrowable();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RetryNotificationDematerializer
    implements Func1<Observable<? extends Notification<?>>, Observable<?>> {
        final Func1<? super Observable<? extends Throwable>, ? extends Observable<?>> notificationHandler;

        public RetryNotificationDematerializer(Func1<? super Observable<? extends Throwable>, ? extends Observable<?>> notificationHandler) {
            this.notificationHandler = notificationHandler;
        }

        @Override
        public Observable<?> call(Observable<? extends Notification<?>> notifications) {
            return this.notificationHandler.call(notifications.map(ERROR_EXTRACTOR));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SelectorAndObserveOn<T, R>
    implements Func1<Observable<T>, Observable<R>> {
        final Func1<? super Observable<T>, ? extends Observable<R>> selector;
        final Scheduler scheduler;

        public SelectorAndObserveOn(Func1<? super Observable<T>, ? extends Observable<R>> selector, Scheduler scheduler) {
            this.selector = selector;
            this.scheduler = scheduler;
        }

        @Override
        public Observable<R> call(Observable<T> t) {
            return this.selector.call(t).observeOn(this.scheduler);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ReturnsVoidFunc1
    implements Func1<Object, Void> {
        ReturnsVoidFunc1() {
        }

        @Override
        public Void call(Object t) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class RepeatNotificationDematerializer
    implements Func1<Observable<? extends Notification<?>>, Observable<?>> {
        final Func1<? super Observable<? extends Void>, ? extends Observable<?>> notificationHandler;

        public RepeatNotificationDematerializer(Func1<? super Observable<? extends Void>, ? extends Observable<?>> notificationHandler) {
            this.notificationHandler = notificationHandler;
        }

        @Override
        public Observable<?> call(Observable<? extends Notification<?>> notifications) {
            return this.notificationHandler.call(notifications.map(RETURNS_VOID));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IsInstanceOfFunc1
    implements Func1<Object, Boolean> {
        final Class<?> clazz;

        public IsInstanceOfFunc1(Class<?> other) {
            this.clazz = other;
        }

        @Override
        public Boolean call(Object t) {
            return this.clazz.isInstance(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class EqualsWithFunc1
    implements Func1<Object, Boolean> {
        final Object other;

        public EqualsWithFunc1(Object other) {
            this.other = other;
        }

        @Override
        public Boolean call(Object t) {
            return t == this.other || t != null && t.equals(this.other);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ToArrayFunc1
    implements Func1<List<? extends Observable<?>>, Observable<?>[]> {
        ToArrayFunc1() {
        }

        @Override
        public Observable<?>[] call(List<? extends Observable<?>> o) {
            return o.toArray(new Observable[o.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ObjectEqualsFunc2
    implements Func2<Object, Object, Boolean> {
        ObjectEqualsFunc2() {
        }

        @Override
        public Boolean call(Object first, Object second) {
            return first == second || first != null && first.equals(second);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class PlusOneLongFunc2
    implements Func2<Long, Object, Long> {
        PlusOneLongFunc2() {
        }

        @Override
        public Long call(Long count, Object o) {
            return count + 1L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class PlusOneFunc2
    implements Func2<Integer, Object, Integer> {
        PlusOneFunc2() {
        }

        @Override
        public Integer call(Integer count, Object o) {
            return count + 1;
        }
    }
}

