package com.zoyi.channel.plugin.android.activity.chat.contract;

import android.net.Uri;
import android.support.annotation.NonNull;

import com.zoyi.channel.plugin.android.activity.chat.model.SendFileItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendItem;
import com.zoyi.channel.plugin.android.activity.chat.model.ProfileBotMessageItem;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.contract.BaseAdapterPresenter;
import com.zoyi.channel.plugin.android.contract.BaseView;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;

import java.util.List;

public interface ChatContract {

  interface View extends BaseView {

    void onFetchStateChange(FetchState fetchState);

    void onWelcomeStateChange(ChatContentType contentType, boolean acceptInput);

    void onChatStateChange(UserChat userChat, Message message, boolean acceptInput, boolean temporaryInputOpened);

    boolean isScrollOnBottom();

    void scrollToBottom();

    void showNewMessageAlert(ProfileEntity profileEntity);

    void showCountryDialog(List<Country> countries, ProfileBotMessageItem item);

    void setInputDim(boolean enabled);
  }

  interface Presenter extends BaseAdapterPresenter {

    void fetchBackwardMessages();

    void sendText(String message);

    void uploadFiles(List<PhotoItem> photoItems);

    void onActionClick(@NonNull String actionType, @NonNull ActionButton actionButton);

    void onCreateSupportBotClick();

    void resend(SendItem item);

    void removeFailedItem(SendItem item);

    void cancelSendingFile(SendFileItem item);

    void requestCountries(ProfileBotMessageItem item);

    void selectCountry(String countryCode, ProfileBotMessageItem item);

    void updateProfile(ProfileBotMessageItem item);
  }
}
