package com.zoyi.channel.plugin.android;


import com.zoyi.channel.plugin.android.global.Const;

import java.util.Locale;

public enum CHLocale {
  KOREAN(Const.KOREAN),
  JAPANESE(Const.JAPANESE),
  ENGLISH(Const.ENGLISH);

  final String string;

  CHLocale(String string) {
    this.string = string;
  }

  public static CHLocale fromString(String languageCode) {
    if (languageCode != null) {
      switch (languageCode) {
        case Const.KOREAN:
          return KOREAN;
        case Const.JAPANESE:
          return JAPANESE;
        case Const.ENGLISH:
          return ENGLISH;
      }
    }
    // else null or invalid language code, catch device locale
    return getDeviceLocale();
  }

  static CHLocale getDeviceLocale() {
    String languageCode = Locale.getDefault().getLanguage();

    if (languageCode != null) {
      switch (languageCode) {
        case Const.KOREAN:
          return KOREAN;
        case Const.JAPANESE:
          return JAPANESE;
      }
    }
    return ENGLISH;
  }

  @Override
  public String toString() {
    return string;
  }
}
