package com.zoyi.channel.plugin.android.view.youtube.player.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.rx.functions.Action0;

public class NetworkListener extends BroadcastReceiver {

  @Nullable
  private Action0 onNetworkUnavailable;

  @Nullable
  private Action0 onNetworkAvailable;

  public void setOnNetworkUnavailable(@NonNull Action0 onNetworkUnavailable) {
    this.onNetworkUnavailable = onNetworkUnavailable;
  }

  public void setOnNetworkAvailable(@NonNull Action0 onNetworkAvailable) {
    this.onNetworkAvailable = onNetworkAvailable;
  }

  @Override
  public void onReceive(Context context, Intent intent) {
    if (Utils.isOnline(context) && onNetworkAvailable != null) {
      onNetworkAvailable.call();
    } else if (onNetworkUnavailable != null) {
      onNetworkUnavailable.call();
    }
  }
}