package com.zoyi.channel.plugin.android.selector;

import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.store.ManagerStore;
import com.zoyi.channel.plugin.android.store.TimerStore;
import com.zoyi.channel.plugin.android.store.base.Store;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.store.binder.Binder4;
import com.zoyi.channel.plugin.android.store.state.CollectionState;
import com.zoyi.channel.plugin.android.store.state.EntityMapState;
import com.zoyi.channel.plugin.android.store.state.State;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.rx.functions.Action2;

import java.util.ArrayList;
import java.util.List;

public class ManagerSelector {

  public static Binder bindFollowingManagers(Action2<List<Manager>, Boolean> action2) {
    EntityMapState<Manager> managersState = ManagerStore.get().managers;
    CollectionState<String> followingManagerIdsState = ManagerStore.get().followingManagerIds;
    State<Channel> channelState = ChannelStore.get().channelState;
    State<Long> nowState = TimerStore.get().now;

    return new Binder4<>(
        managersState,
        followingManagerIdsState,
        channelState,
        nowState
    ).bind((managers, followingManagerIds, channel, now) -> {
      int remainMinutes = ChannelUtils.getMinutesLeftToWork(channel, now);

      if (remainMinutes != 0) {
        action2.call(null, false);
      } else if (managers != null && followingManagerIds != null) {
        List<Manager> followingManagers = new ArrayList<>();

        for (String managerId : followingManagerIds) {
          Manager manager = managers.get(managerId);

          if (manager != null) {
            followingManagers.add(manager);
          }
        }

        action2.call(followingManagers, true);
      }
    });
  }
}
